/**
 * 添加自定义的验证规则
 */

export function isvalidUsername(str) {
    const valid_map = ['admin', 'editor']
    return valid_map.indexOf(str.trim()) >= 0
  }
  
  /* 合法uri*/
  export function validateURL(textval) {
    const urlregex = /^(https?|ftp):\/\/([a-zA-Z0-9.-]+(:[a-zA-Z0-9.&%$-]+)*@)*((25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]?)(\.(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])){3}|([a-zA-Z0-9-]+\.)*[a-zA-Z0-9-]+\.(com|edu|gov|int|mil|net|org|biz|arpa|info|name|pro|aero|coop|museum|[a-zA-Z]{2}))(:[0-9]+)*(\/($|[a-zA-Z0-9.,?'\\+&%$#=~_-]+))*$/
    return urlregex.test(textval)
  }
  
  /* 小写字母*/
  export function validateLowerCase(str) {
    const reg = /^[a-z]+$/
    return reg.test(str)
  }
  
  /* 大写字母*/
  export function validateUpperCase(str) {
    const reg = /^[A-Z]+$/
    return reg.test(str)
  }
  
  /* 大小写字母*/
  export function validatAlphabets(str) {
    const reg = /^[A-Za-z]+$/
    return reg.test(str)
  }

  // 2-150个中英文字符
  export function validateWord150(rule, value, callback, message) {
      if(!/^[\u4e00-\u9fffa-zA-Z]{2,150}$/.test(value)) {
        callback(new Error(message))
      } else {
        callback()
      }
  }
  // 考试30个中英文字符
  export function validateWord30(value,message) {
    if(!/^[\u4e00-\u9fffa-zA-Z]{0,30}$/.test(value)) {
      callback(new Error('考试名称长度不超过30个中文字符长度'))
    } else {
      callback()
    }
}
  /* 通用密码验证(数字、字母、下划线或特殊字符且长度为0-150位) */
export function isValidPassword(rule, value, callback, message) {
    if (!/^(?:\d+|[a-zA-Z]+|[!@#$%^&*]+){0,150}$/.test(value)) {
      callback(new Error(message))
    } else {
      callback()
    }
}
  
  