import { checkMobile } from '@/utils/followup/followupUtils/checkField'

export default ($this) => {
  return [
    {
      formType: 'input',
      className: 'float-none',
      prop: 'followUpOrgName',
      model: 'followUpOrgName',
      label: '履约单位名称：',
      disabled: false,
      placeholder: '请输入履约单位名称',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      labmsg: '次',
      rules: [
        {
          required: true,
          message: '请输入履约单位名称',
          trigger: ['submit', 'change'],
        },
      ],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'followUpUser',
      model: 'followUpUser',
      label: '履约人员姓名：',
      disabled: false,
      placeholder: '请输入履约人员姓名',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      labmsg: '次',
      rules: [
        {
          required: true,
          message: '请输入履约人员姓名',
          trigger: ['submit', 'change'],
        },
      ],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'followUpMobile',
      model: 'followUpMobile',
      label: '履约人员联系电话：',
      disabled: false,
      placeholder: '请输入履约人员联系电话',
      spanNum: 12,
      maxlength: 11,
      type: 'tel',
      labmsg: '次',
      rules: [
        {
          required: true,
          message: '请输入履约人员联系电话',
          trigger: ['submit', 'change'],
        },
        { validator: checkMobile, trigger: ['submit', 'change'] },
      ],
    },
    {
      formType: 'date-picker',
      className: 'float-none',
      prop: 'surveyTime',
      model: 'surveyTime',
      placeholder: '请选择',
      label: '本次调查时间：',
      format: 'yyyy-MM-dd',
      valueFormat: 'yyyy-MM-dd',
      dateType: 'date',
      type: 'date',
      rules: [
        {
          required: true,
          message: '请选择本次调查时间',
          trigger: ['submit', 'change'],
        },
      ],
      spanNum: 12,
    },
  ]
}
