import * as Vue from 'vue'
import App from '../App'
import patientsRouters from './patients'
import followRouters from './follow'

const login = Vue.defineAsyncComponent(() => import('../views/login'))

const home = Vue.defineAsyncComponent(() => import('../views/home'))
const blank = Vue.defineAsyncComponent(() => import('../views/blank'))
const itemManager = Vue.defineAsyncComponent(
  () => import('../views/education/item-manager.vue')
)
const itemComponent = Vue.defineAsyncComponent(
  () => import('../views/education/item-component.vue')
)
const createComponent = Vue.defineAsyncComponent(
  () => import('../views/education/create-component.vue')
)
const roleManager = Vue.defineAsyncComponent(
  () => import('../views/system/role.vue')
)
const circleLimit = Vue.defineAsyncComponent(
  () => import('../views/system/circle-limit.vue')
)
const addManager = Vue.defineAsyncComponent(
  () => import('../views/education/add-manager.vue')
)
const editManager = Vue.defineAsyncComponent(
  () => import('../views/education/edit-manager.vue')
)
const itemRole = Vue.defineAsyncComponent(
  () => import('../views/system/item-role.vue')
)
const msgPush = Vue.defineAsyncComponent(
  () => import('../views/msgpush/msg-push.vue')
)
const editCme = Vue.defineAsyncComponent(
  () => import('../views/education/edit-cme.vue')
)
const editProfessionalExam = Vue.defineAsyncComponent(
  () => import('../views/education/edit-professional-exam.vue')
)
const subjectManager = Vue.defineAsyncComponent(
  () => import('../views/education/subject-manager.vue')
)
const editSubject = Vue.defineAsyncComponent(
  () => import('../views/education/edit-subject.vue')
)
const reportDownload = Vue.defineAsyncComponent(
  () => import('../views/education/report-download.vue')
)
const teachingPopup = Vue.defineAsyncComponent(
  () => import('../views/education/teaching-popup.vue')
)
const editeachPopup = Vue.defineAsyncComponent(
  () => import('../views/education/editeach-popup.vue')
)

const reportLisOld = Vue.defineAsyncComponent(
  () => import('../views/learning-o/report-list.vue')
)
const itemListOld = Vue.defineAsyncComponent(
  () => import('../views/learning-o/item-list.vue')
)
const nameListOld = Vue.defineAsyncComponent(
  () => import('../views/learning-o/name-list.vue')
)
const dataAlignmentOld = Vue.defineAsyncComponent(
  () => import('../views/learning-o/data-alignment.vue')
)
const exportDownloadOld = Vue.defineAsyncComponent(
  () => import('../views/learning-o/export-download.vue')
)

const reportLis = Vue.defineAsyncComponent(
  () => import('../views/learning/report-list.vue')
)
const itemList = Vue.defineAsyncComponent(
  () => import('../views/learning/item-list.vue')
)
const nameList = Vue.defineAsyncComponent(
  () => import('../views/learning/name-list.vue')
)
const dataAlignment = Vue.defineAsyncComponent(
  () => import('../views/learning/data-alignment.vue')
)
const exportDownload = Vue.defineAsyncComponent(
  () => import('../views/learning/export-download.vue')
)

const itemShield = Vue.defineAsyncComponent(
  () => import('../views/education/item-shield.vue')
)
const entryManager = Vue.defineAsyncComponent(
  () => import('../views/education/entry-manager.vue')
)
const editEntry = Vue.defineAsyncComponent(
  () => import('../views/education/edit-entry.vue')
)
const editNotice = Vue.defineAsyncComponent(
  () => import('../views/education/edit-notice.vue')
)

const creditManage = Vue.defineAsyncComponent(
  () => import('../views/cme/credit-manage.vue')
)
const reviewAccessManage = Vue.defineAsyncComponent(
  () => import('../views/cme/review-access-manage.vue')
)
const creditSendManage = Vue.defineAsyncComponent(
  () => import('../views/cme/credit-send-manage.vue')
)
const applyDetail = Vue.defineAsyncComponent(
  () => import('../views/cme/apply-detail.vue')
)

const templateManager = Vue.defineAsyncComponent(
  () => import('../views/education/template-manager.vue')
)
const templateEditor = Vue.defineAsyncComponent(
  () => import('../views/education/template-editor.vue')
)
const templateOpen = Vue.defineAsyncComponent(
  () => import('../views/education/template-open.vue')
)
const eduRole = Vue.defineAsyncComponent(
  () => import('../views/education/edu-role.vue')
)
const editCustom = Vue.defineAsyncComponent(
  () => import('../views/education/edit-custom.vue')
)
const externalResourceManage = Vue.defineAsyncComponent(
  () => import('../views/education/external-resource-manage.vue')
)
const auditCustomCourse = Vue.defineAsyncComponent(
  () => import('../views/education/audit-custom-course.vue')
)
const advertSimpleManage = Vue.defineAsyncComponent(
  () => import('../views/education/advert/advert-simple-manage.vue')
)
const editSimpleAdvert = Vue.defineAsyncComponent(
  () => import('../views/education/advert/edit-simple-advert.vue')
)

const noticeEditor = Vue.defineAsyncComponent(
  () => import('../views/education/notice-editor.vue')
)

const activityManagement = Vue.defineAsyncComponent(
  () => import('../views/activitymanagement/activity-management.vue')
)
const createActivity = Vue.defineAsyncComponent(
  () => import('../views/activitymanagement/create-activity.vue')
)

const yqRange = Vue.defineAsyncComponent(
  () => import('../views/yqrange/yq-range.vue')
)
const liveManage = Vue.defineAsyncComponent(
  () => import('../views/yqrange/live-manage.vue')
)
const roleManage = Vue.defineAsyncComponent(
  () => import('../views/yqrange/role-manage.vue')
)
const createRange = Vue.defineAsyncComponent(
  () => import('../views/yqrange/create-range.vue')
)
const rangeManage = Vue.defineAsyncComponent(
  () => import('../views/yqrange/range-manage.vue')
)
const editRange = Vue.defineAsyncComponent(
  () => import('../views/yqrange/edit-range.vue')
)
const createLive = Vue.defineAsyncComponent(
  () => import('../views/yqrange/create-live.vue')
)
const blackListManage = Vue.defineAsyncComponent(
  () => import('../views/yqrange/blacklist-manage.vue')
)
const adminManage = Vue.defineAsyncComponent(
  () => import('../views/yqrange/admin-manage.vue')
)
const rangeApply = Vue.defineAsyncComponent(
  () => import('../views/yqrange/range-apply.vue')
)

const shopList = Vue.defineAsyncComponent(
  () => import('../views/shop/shop-list.vue')
)
const createShop = Vue.defineAsyncComponent(
  () => import('../views/shop/create-shop.vue')
)
const goodsManage = Vue.defineAsyncComponent(
  () => import('../views/goods/goods-manage.vue')
)
const freightConfig = Vue.defineAsyncComponent(
  () => import('../views/freight/freight-config.vue')
)
const createGood = Vue.defineAsyncComponent(
  () => import('../views/goods/create-good.vue')
)
const createGoodNew = Vue.defineAsyncComponent(
  () => import('../views/goods/create-good-new.vue')
)
const orderManage = Vue.defineAsyncComponent(
  () => import('../views/goods/order-manage.vue')
)
const orderDetail = Vue.defineAsyncComponent(
  () => import('../views/goods/order-detail.vue')
)
const plazaList = Vue.defineAsyncComponent(
  () => import('../views/plaza/plaza-list.vue')
)
const activityMember = Vue.defineAsyncComponent(
  () => import('../views/activitymanagement/activity-member.vue')
)

const videoManage = Vue.defineAsyncComponent(
  () => import('../views/shortvideo/video-manage.vue')
)
const qualificationList = Vue.defineAsyncComponent(
  () => import('../views/qualification/list.vue')
)
const qualificationDetail = Vue.defineAsyncComponent(
  () => import('../views/qualification/detail.vue')
)

export default [
  {
    path: '/',
    component: App,
    children: [
      {
        path: '/login',
        component: login,
        name: 'loginPage',
      },
      {
        path: '',
        redirect: '/home',
      },
      {
        path: '/index',
        component: home,
      },
      {
        path: '/home',
        component: home,
      },
      {
        path: '/blank',
        component: blank,
      },
      {
        path: '/item-manager',
        component: itemManager,
      },
      {
        path: '/add-manager',
        component: addManager,
      },
      {
        path: '/edit-manager',
        component: editManager,
      },
      {
        path: '/edit-cme',
        component: editCme,
      },
      {
        path: '/edit-professional-exam',
        component: editProfessionalExam,
      },
      {
        path: '/subject-manager',
        component: subjectManager,
      },
      {
        path: '/report-download',
        component: reportDownload,
      },
      {
        path: '/teaching-popup',
        component: teachingPopup,
      },
      {
        path: '/editeach-popup',
        component: editeachPopup,
      },
      {
        path: '/edit-subject',
        component: editSubject,
      },
      {
        path: '/item-component',
        component: itemComponent,
      },
      {
        path: '/role',
        component: roleManager,
      },
      {
        path: '/circle-limit',
        component: circleLimit,
      },
      {
        path: '/create-component',
        component: createComponent,
      },
      {
        path: '/item-role',
        component: itemRole,
      },
      {
        path: '/report-list',
        component: reportLis,
      },
      {
        path: '/item-list',
        component: itemList,
      },
      {
        path: '/data-alignment',
        component: dataAlignment,
      },
      {
        path: '/name-list',
        component: nameList,
      },
      {
        path: '/export-download',
        component: exportDownload,
      },

      {
        path: '/report-list-old',
        component: reportLisOld,
      },
      {
        path: '/item-list-old',
        component: itemListOld,
      },
      {
        path: '/data-alignment-old',
        component: dataAlignmentOld,
      },
      {
        path: '/name-list-old',
        component: nameListOld,
      },
      {
        path: '/export-download-old',
        component: exportDownloadOld,
      },

      {
        path: '/item-shield',
        component: itemShield,
      },
      {
        path: '/entry-manager',
        component: entryManager,
      },
      {
        path: '/edit-entry',
        component: editEntry,
      },
      {
        path: '/msg-push',
        component: msgPush,
        // redirect: 'msgpush/msg-push',
      },
      {
        path: '/edit-notice',
        component: editNotice,
        // redirect: 'msgpush/msg-push',
      },
      {
        path: '/credit-manage',
        component: creditManage,
      },
      {
        path: '/review-access-manage',
        component: reviewAccessManage,
      },
      {
        path: '/credit-send-manage',
        component: creditSendManage,
      },
      {
        path: '/apply-detail',
        component: applyDetail,
      },
      {
        path: '/template-manager',
        component: templateManager,
      },
      {
        path: '/template-editor',
        component: templateEditor,
      },
      {
        path: '/template-open',
        component: templateOpen,
      },
      {
        path: '/edit-custom',
        component: editCustom,
      },
      {
        path: '/edu-role',
        component: eduRole,
      },
      {
        path: '/notice-editor',
        component: noticeEditor,
      },
      {
        path: '/yq-range',
        component: yqRange,
      },
      {
        path: '/activity-management',
        component: activityManagement,
      },
      {
        path: '/create-activity',
        component: createActivity,
      },
      {
        path: '/live-manage',
        component: liveManage,
      },
      {
        path: '/role-manage',
        component: roleManage,
      },
      {
        path: '/admin-manage',
        component: adminManage,
      },
      {
        path: '/create-range',
        component: createRange,
      },
      {
        path: '/range-manage',
        component: rangeManage,
      },
      {
        path: '/range-apply',
        component: rangeApply,
      },
      {
        path: '/create-live',
        component: createLive,
      },
      {
        path: '/edit-range',
        component: editRange,
      },
      {
        path: '/blacklist-manage',
        component: blackListManage,
      },
      {
        path: '/external-resource-manage',
        component: externalResourceManage,
      },
      {
        path: '/audit-custom-course',
        component: auditCustomCourse,
      },
      {
        path: '/advert-simple-manage',
        component: advertSimpleManage,
      },
      {
        path: '/edit-simple-advert',
        component: editSimpleAdvert,
      },
      {
        path: '/shop-list',
        component: shopList,
      },
      {
        path: '/create-shop',
        component: createShop,
      },
      {
        path: '/order-manage',
        component: orderManage,
      },
      {
        path: '/goods-manage',
        component: goodsManage,
      },
      {
        path: '/freight-config',
        component: freightConfig,
      },
      {
        path: '/create-good',
        component: createGood,
      },
      {
        path: '/create-good-new',
        component: createGoodNew,
      },
      {
        path: '/order-detail',
        component: orderDetail,
      },
      {
        path: '/plaza-list',
        component: plazaList,
      },
      {
        path: '/activity-member',
        component: activityMember,
      },
      {
        path: 'video-manage',
        component: videoManage,
      },
      {
        path: 'qualification-list',
        component: qualificationList,
      },
      {
        path: 'qualification-detail',
        component: qualificationDetail,
      },
      // {
      //   path: '/followup',
      //   name: 'followUp',
      //   component: followUp,
      //   redirect: 'followup/plan-manage/planList',
      // },
      followRouters,
      patientsRouters,
    ],
  },
]
