import fetch from '../fetch'
import { getBaseUrl, getSaasDomain, getSaasApiDomain } from '@/utils/index'
let headers = {
  'Content-Type': 'application/json;charset=UTF-8',
  token: localStorage.getItem('storageToken'),
}
export const getCertifyList = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`store/certify/list`),
    method: 'post',
    data: params,
    description: '审核记录列表(批发和供应商)',
  })
}
export const getCertifyHistory = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`certify/certifyHistory`),
    method: 'get',
    data: params,
    description: '查看审核历史',
  })
}
export const getCertifyDetail = () => {
  return fetch({
    headers,
    url: getBaseUrl(`store/certify/certifyDetail`),
    method: 'get',
    description: '获取认证申请的审核详情',
  })
}
export const getRefuseTemplate = (type) => {
  return fetch({
    headers,
    url: getBaseUrl(`store/cert/constant/refuse/template?type=${type}`),
    method: 'get',
    description: '获取错误模板',
  })
}
export const postCertifyAudit = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`store/certify/audit`),
    method: 'post',
    data: params,
    description: '审核',
  })
}
