const patientsManage = r => require.ensure([], () => r(require('../views/patients/layout.vue')), 'patientsManage');
/*我的居民*/
const myPatientsManage = r => require.ensure([], () => r(require('../views/patients/mypatients-manage/layout.vue')), 'myPatientsManage');
const patientsList = r => require.ensure([], () => r(require('../views/patients/mypatients-manage/patients-list.vue')), 'patientsList');

/*新增居民*/
const newManage = r => require.ensure([], () => r(require('../views/patients/new-manage/layout.vue')), 'newManage');
const newPatient = r => require.ensure([], () => r(require('../views/patients/new-manage/new-patient.vue')), 'newPatient');

/*分组管理*/
const labelsManage = r => require.ensure([], () => r(require('../views/patients/labels-manage/layout.vue')), 'labelsManage');
const labelsList = r => require.ensure([], () => r(require('../views/patients/labels-manage/labels-manage.vue')), 'labelsList');

/*资料不全居民*/
const halfDataManage = r => require.ensure([], () => r(require('../views/patients/half-data-manage/layout.vue')), 'halfDataManage');
const halfDataList = r => require.ensure([], () => r(require('../views/patients/half-data-manage/half-data-list.vue')), 'halfDataList');

const patientsRouters = {
  path: '/patients-manage',
  name: 'patientsManage',
  component: patientsManage,
  redirect: 'patients-manage/mypatients-manage/patients-list',
  children: [
    {
      path: 'mypatients-manage',
      component: myPatientsManage,
      name: 'myPatientsManage',
      redirect: 'mypatients-manage/patients-list',
      children: [
        {
          path: 'patients-list',
          component: patientsList,
          name: 'patientsList',
          meta: {
            title: '我的居民列表',
            keepAlive: false  //页面不需要缓存
          },
        }
      ],
      meta: {
        title: '我的居民',
      },
    },
    {
      path: 'new-manage',
      component: newManage,
      name: 'newManage',
      redirect: 'new-manage/new-patient',
      children: [
        {
          path: 'new-patient',
          component: newPatient,
          name: 'newPatient',
          meta: {
            title: '新增居民',
            keepAlive: false
          },
        },
      ],
      meta: {
        title: '新增居民',
      },
    },
    {
      path: 'labels-manage',
      component: labelsManage,
      name: 'labelsManage',
      redirect: 'labels-manage/labels-manage',
      children: [
        {
          path: 'labels-manage',
          component: labelsList,
          name: 'labelsList',
          meta: {
            title: '分组管理',
            keepAlive: false
          },
        },
      ],
      meta: {
        title: '分组管理',
      },
    },
    {
      path: 'half-data-manage',
      component: halfDataManage,
      name: 'halfDataManage',
      redirect: 'half-data-manage/half-data-list',
      children: [
        {
          path: 'half-data-list',
          component: halfDataList,
          name: 'halfDataList',
          meta: {
            title: '资料不全居民',
            keepAlive: false
          },
        },
      ],
      meta: {
        title: '资料不全居民',
      },
    },
  ],
};

export default patientsRouters
