const patientsManage = (r) =>
  require.ensure(
    [],
    () => r(require('../views/patients/layout.vue')),
    'patientsManage'
  )
/*我的居民*/
const myPatientsManage = (r) =>
  require.ensure(
    [],
    () => r(require('../views/patients/mypatients-manage/layout.vue')),
    'myPatientsManage'
  )
const patientsList = (r) =>
  require.ensure(
    [],
    () => r(require('../views/patients/mypatients-manage/patients-list.vue')),
    'patientsList'
  )
const patientDetail = (r) =>
  require.ensure(
    [],
    () => r(require('../views/patients/mypatients-manage/patient-detail.vue')),
    'patientDetail'
  )
const basicInfo = (r) =>
  require.ensure(
    [],
    () => r(require('../views/patients/mypatients-manage/basic-info.vue')),
    'basicInfo'
  )

/*新增居民*/
const newManage = (r) =>
  require.ensure(
    [],
    () => r(require('../views/patients/new-manage/layout.vue')),
    'newManage'
  )
const newPatient = (r) =>
  require.ensure(
    [],
    () => r(require('../views/patients/new-manage/new-patient.vue')),
    'newPatient'
  )

/*分组管理*/
const labelsManage = (r) =>
  require.ensure(
    [],
    () => r(require('../views/patients/labels-manage/layout.vue')),
    'labelsManage'
  )
const labelsList = (r) =>
  require.ensure(
    [],
    () => r(require('../views/patients/labels-manage/labels-list.vue')),
    'labelsList'
  )
const labelsDetail = (r) =>
  require.ensure(
    [],
    () => r(require('../views/patients/labels-manage/labels-detail.vue')),
    'labelsDetail'
  )

/*资料不全居民*/
const notCompleteManage = (r) =>
  require.ensure(
    [],
    () => r(require('../views/patients/not-complete/layout.vue')),
    'halfDataManage'
  )
const notCompleteList = (r) =>
  require.ensure(
    [],
    () => r(require('../views/patients/not-complete/not-complete-list.vue')),
    'halfDataList'
  )

const patientsRouters = {
  path: '/patients-manage',
  name: 'patientsManage',
  component: patientsManage,
  redirect: 'patients-manage/mypatients-manage/patients-list',
  children: [
    {
      path: 'mypatients-manage',
      component: myPatientsManage,
      name: 'myPatientsManage',
      redirect: 'mypatients-manage/patients-list',
      children: [
        {
          path: 'patients-list',
          component: patientsList,
          name: 'patientsList',
          meta: {
            title: '我的居民列表',
            keepAlive: false, //页面不需要缓存
            checkAuth: true,
          },
        },
        {
          path: 'patient-detail',
          component: patientDetail,
          name: 'patientDetail',
          meta: {
            title: '居民详情',
            keepAlive: false,
          },
        },
        {
          path: 'basic-info',
          component: basicInfo,
          name: 'basicInfo',
          meta: {
            title: '居民详情',
            keepAlive: false,
          },
        },
      ],
      meta: {
        title: '我的居民',
      },
    },
    {
      path: 'new-manage',
      component: newManage,
      name: 'newManage',
      redirect: 'new-manage/new-patient',
      children: [
        {
          path: 'new-patient',
          component: newPatient,
          name: 'newPatient',
          meta: {
            title: '新增居民',
            keepAlive: false,
            checkAuth: true,
            doctorAuth: true,
          },
        },
      ],
      meta: {
        title: '新增居民',
      },
    },
    {
      path: 'labels-manage',
      component: labelsManage,
      name: 'labelsManage',
      redirect: 'labels-manage/labels-list',
      children: [
        {
          path: 'labels-list',
          component: labelsList,
          name: 'labelsList',
          meta: {
            title: '分组管理',
            keepAlive: false,
            checkAuth: true,
          },
        },
        {
          path: 'labels-detail',
          component: labelsDetail,
          name: 'labelsDetail',
          meta: {
            title: '分组详情',
            keepAlive: false,
          },
        },
      ],
      meta: {
        title: '分组管理',
      },
    },
    {
      path: 'not-complete',
      component: notCompleteManage,
      name: 'notCompleteManage',
      redirect: 'not-complete/uncompleted-list',
      children: [
        {
          path: 'uncompleted-list',
          component: notCompleteList,
          name: 'notCompleteList',
          meta: {
            title: '资料不全居民',
            keepAlive: false,
            checkAuth: true,
          },
        },
      ],
      meta: {
        title: '资料不全居民',
      },
    },
  ],
}

export default patientsRouters
