const customStore = {
  // namespaced: true,
  state: {
    kind: 0,
    searchParam: {
      kind: 0,
      orderBy: 2,
      dir: 1,
      grade: 0,
      pageNo: 1,
      pageSize: 10,
      labelIdList: [],
    },
    searchParamOrg: {
      kind: 1,
      orderBy: 2,
      dir: 1,
      grade: 0,
      pageNo: 1,
      pageSize: 10,
      labelIdList: [],
    },
    cartList: [],
    courseList: [],
    allLabelList: [],
    subLabelList: [],
    allLabelListOrg: [],
    subLabelListOrg: [],
    courseLimitCount: -1, // -1: 不限制; 其它值: 限制的个数
  },
  mutations: {
    SET_KIND: (state, kind) => {
      state.kind = kind
    },
    SET_SEARCH_PARAM: (state, searchParam) => {
      state.searchParam = searchParam
    },
    SET_SEARCH_PARAM_ORG: (state, searchParamOrg) => {
      state.searchParamOrg = searchParamOrg
    },
    SET_CART_LIST: (state, cartList) => {
      state.cartList = cartList
    },
    SET_COURSE_LIST: (state, courseList) => {
      state.courseList = courseList
    },
    SET_ALL_LABEL_LIST: (state, allLabelList) => {
      state.allLabelList = allLabelList
    },
    SET_SUB_LABEL_LIST: (state, subLabelList) => {
      state.subLabelList = subLabelList
    },
    SET_ALL_LABEL_LIST_ORG: (state, allLabelListOrg) => {
      state.allLabelListOrg = allLabelListOrg
    },
    SET_SUB_LABEL_LIST_ORG: (state, subLabelListOrg) => {
      state.subLabelListOrg = subLabelListOrg
    },
    SET_COURSE_LIMIT_COUNT: (state, courseLimitCount) => {
      state.courseLimitCount = courseLimitCount
    },
  },
  actions: {
    setKind({ commit }, kind) {
      commit('SET_KIND', kind)
    },
    setSearchParam({ commit }, searchParam) {
      commit('SET_SEARCH_PARAM', searchParam)
    },
    setSearchParamOrg({ commit }, searchParamOrg) {
      commit('SET_SEARCH_PARAM_ORG', searchParamOrg)
    },
    setCartList({ commit }, cartList) {
      commit('SET_CART_LIST', cartList)
    },
    setCourseList({ commit }, courseList) {
      commit('SET_COURSE_LIST', courseList)
    },
    setAllLabelList({ commit }, allLabelList) {
      commit('SET_ALL_LABEL_LIST', allLabelList)
    },
    setSubLabelList({ commit }, subLabelList) {
      commit('SET_SUB_LABEL_LIST', subLabelList)
    },
    setAllLabelListOrg({ commit }, allLabelListOrg) {
      commit('SET_ALL_LABEL_LIST_ORG', allLabelListOrg)
    },
    setSubLabelListOrg({ commit }, subLabelListOrg) {
      commit('SET_SUB_LABEL_LIST_ORG', subLabelListOrg)
    },
    setCourseLimitCount({ commit }, courseLimitCount) {
      commit('SET_COURSE_LIMIT_COUNT', courseLimitCount)
    },
  },
}

export default customStore
