import {
  getTodayAppointsList,
  getTodayOverview,
  getTodayPlans,
} from '@/utils/followup/followapis'

export default {
  namespaced: true,
  state: {
    todayPlansList: [], //今日履约列表
    todayAppointsList: [], //今日预约列表
    todayOverview: [], //查询今日履约、预约、履约人数count
  },
  mutations: {
    GET_TODAY_PLAN_LIST(state, payload) {
      // console.log('返回数据', payload)
      state.todayPlansList = payload
    },
    GET_TODAY_APPOINTS_LIST(state, payload) {
      state.todayAppointsList = payload
    },
    GET_TODAY_OVERVIEW(state, payload) {
      state.todayOverview = payload
    },
  },
  actions: {
    getTodayPlansList(context, payload) {
      getTodayPlans({
        ...payload,
      }).then(({ data }) => {
        context.commit('GET_TODAY_PLAN_LIST', data)
      })
    },
    getTodayAppointsList(context, payload) {
      getTodayAppointsList({
        ...payload,
      }).then(({ data }) => {
        context.commit('GET_TODAY_APPOINTS_LIST', data)
      })
    },
    getTodayOverview(context, payload) {
      getTodayOverview({
        ...payload,
      }).then(({ data }) => {
        context.commit('GET_TODAY_OVERVIEW', data)
      })
    },
  },
}
