import fetch from '../fetch'
import { getBaseUrl, getSaasDomain, getSaasApiDomain } from '@/utils/index'
let headers = {
  'Content-Type': 'application/json;charset=UTF-8',
  token: localStorage.getItem('storageToken'),
}

export const getDiseaseList = () => {
  return fetch({
    headers,
    url: getBaseUrl(`sticker/disease/listAll`),
    method: 'get',
    description: '疾病标签列表（所有）',
  })
}

export const getDeptList = () => {
  return fetch({
    headers,
    url: getBaseUrl(`sticker/subject/childListAll`),
    method: 'get',
    description: '科室列表-所有二级',
  })
}

export const getSubjectList = () => {
  return fetch({
    headers,
    url: getBaseUrl(`sticker/subject/listAll`),
    method: 'get',
    description: '学科列表-所有2级',
  })
}

export const getPlazaList = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/sso/square/list`),
    method: 'post',
    data: params,
    description: '后台管理--广场内专区列表与搜索',
  })
}

export const savePlaza = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/sso/square/save`),
    method: 'post',
    data: params,
    description: '后台管理--新增编辑广场内专区和标签',
  })
}

export const delPlaza = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/sso/square/remove`),
    method: 'delete',
    params: params,
    description: '后台管理--广场内专区移除',
    withCredentials: true,
  })
}

export const getPlaza = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/sso/square/info?id=${params.id}`),
    method: 'get',
    data: params,
    description: '后台管理--广场内专区信息（查看）',
    withCredentials: true,
  })
}

export const getSelectPlazaList = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/sso/square/circle/list/${params.businessId}`),
    method: 'get',
    description: '后台管理--待选专区列表',
  })
}
