import {
  checkRange,
  checkIsInteger,
  checkNumberIsToFixed,
} from '@/utils/followup/followupUtils/checkField'

export default ($this) => {
  return [
    {
      formType: 'input',
      className: 'float-none',
      prop: 'smokingAmount',
      model: 'smokingAmount',
      disabled: false,
      label: '本次日吸烟量：',
      placeholder: '请输入本次日吸烟量',
      spanNum: 8,
      maxlength: 30,
      type: 'number',
      labmsg: '',
      slots: [{ name: '支/日', type: 'append' }],
      rules: [
        {
          required: true,
          message: '请输入日吸烟量',
          trigger: ['submit', 'change'],
        },
        { validator: checkRange, trigger: ['submit', 'change'] },
        { validator: checkIsInteger, trigger: ['submit', 'change'] },
      ],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'nextSmokingAmount',
      model: 'nextSmokingAmount',
      disabled: false,
      label: '下次履约目标日吸烟量：',
      placeholder: '请输入下次履约日吸烟量',
      spanNum: 8,
      maxlength: 30,
      type: 'number',
      labmsg: '',
      slots: [{ name: '支/日', type: 'append' }],
      rules: [
        {
          required: true,
          message: '请输入下次履约日吸烟量',
          trigger: ['submit', 'change'],
        },
        { validator: checkRange, trigger: ['submit', 'change'] },
        { validator: checkIsInteger, trigger: ['submit', 'change'] },
      ],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'alcoholConsumption',
      model: 'alcoholConsumption',
      disabled: false,
      label: '本次日饮酒量：',
      placeholder: '请输入本次日饮酒量',
      spanNum: 8,
      maxlength: 30,
      type: 'number',
      labmsg: '',
      slots: [{ name: '两/日', type: 'append' }],
      rules: [
        {
          required: true,
          message: '请输入本次日饮酒量',
          trigger: ['submit', 'change'],
        },
        { validator: checkRange, trigger: ['submit', 'change'] },
        { validator: checkIsInteger, trigger: ['submit', 'change'] },
      ],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'nextAlcoholConsumption',
      model: 'nextAlcoholConsumption',
      disabled: false,
      label: '下次履约目标日饮酒量：',
      placeholder: '请输入下次履约日饮酒量',
      spanNum: 8,
      maxlength: 30,
      type: 'number',
      labmsg: '',
      slots: [{ name: '两/日', type: 'append' }],
      rules: [
        {
          required: true,
          message: '请输入下次履约日饮酒量',
          trigger: ['submit', 'change'],
        },
        { validator: checkRange, trigger: ['submit', 'change'] },
        { validator: checkIsInteger, trigger: ['submit', 'change'] },
      ],
    },

    {
      formType: 'input',
      className: 'float-none',
      prop: 'workoutOfWeek',
      model: 'workoutOfWeek',
      disabled: false,
      label: '本次运动情况：',
      placeholder: '请输入本次运动情况',
      spanNum: 8,
      maxlength: 30,
      type: 'number',
      labmsg: '',
      slots: [{ name: '次/周', type: 'append' }],
      rules: [
        {
          required: true,
          message: '请输入本次运动情况',
          trigger: ['submit', 'change'],
        },
        { validator: checkRange, trigger: ['submit', 'change'] },
        { validator: checkIsInteger, trigger: ['submit', 'change'] },
      ],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'workoutDuration',
      model: 'workoutDuration',
      disabled: false,
      placeholder: '请输入本次运动情况',
      spanNum: 8,
      maxlength: 30,
      type: 'number',
      labmsg: '',
      slots: [{ name: '分钟/次', type: 'append' }],
      rules: [
        {
          required: true,
          message: '请输入本次运动情况',
          trigger: ['submit', 'change'],
        },
        { validator: checkRange, trigger: ['submit', 'change'] },
        { validator: checkIsInteger, trigger: ['submit', 'change'] },
      ],
    },

    {
      formType: 'input',
      className: 'float-none',
      prop: 'nextWorkoutOfWeek',
      model: 'nextWorkoutOfWeek',
      disabled: false,
      label: '下次履约目标运动情况：',
      placeholder: '请输入下次履约运动情况',
      spanNum: 8,
      maxlength: 30,
      type: 'number',
      labmsg: '',
      slots: [{ name: '次/周', type: 'append' }],
      rules: [
        {
          required: true,
          message: '请输入下次履约运动情况',
          trigger: ['submit', 'change'],
        },
        { validator: checkRange, trigger: ['submit', 'change'] },
        { validator: checkIsInteger, trigger: ['submit', 'change'] },
      ],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'nextWorkoutDuration',
      model: 'nextWorkoutDuration',
      disabled: false,
      placeholder: '请输入下次履约运动情况',
      spanNum: 8,
      maxlength: 30,
      type: 'number',
      labmsg: '',
      slots: [{ name: '分钟/次', type: 'append' }],
      rules: [
        {
          required: true,
          message: '请输入下次履约运动情况',
          trigger: ['submit', 'change'],
        },
        { validator: checkRange, trigger: ['submit', 'change'] },
        { validator: checkIsInteger, trigger: ['submit', 'change'] },
      ],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'stapleFoodGram',
      model: 'stapleFoodGram',
      disabled: false,
      label: '实际主食摄入量：',
      placeholder: '请输入每天摄入主食克数',
      spanNum: 8,
      maxlength: 30,
      type: 'number',
      labmsg: '',
      slots: [{ name: '克/天', type: 'append' }],
      rules: [
        {
          required: true,
          message: '请输入每天摄入主食克数',
          trigger: ['submit', 'change'],
        },
        { validator: checkRange, trigger: ['submit', 'change'] },
        { validator: checkIsInteger, trigger: ['submit', 'change'] },
      ],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'nextStapleFoodGram',
      model: 'nextStapleFoodGram',
      disabled: false,
      label: '目标主食摄入量：',
      placeholder: '请输入每天摄入主食克数',
      spanNum: 8,
      maxlength: 30,
      type: 'number',
      labmsg: '',
      slots: [{ name: '克/天', type: 'append' }],
      rules: [
        {
          required: true,
          message: '请输入每天摄入主食克数',
          trigger: ['submit', 'change'],
        },
        { validator: checkRange, trigger: ['submit', 'change'] },
        { validator: checkIsInteger, trigger: ['submit', 'change'] },
      ],
    },

    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'psychologicalAdjustment',
      model: 'psychologicalAdjustment',
      spanNum: 24,
      label: '心理调整：',
      options: [
        { label: '良好', value: '良好' },
        { label: '一般', value: '一般' },
        { label: '差', value: '差' },
      ],
      rules: [
        {
          required: true,
          message: '请选择心理调整',
          trigger: ['submit', 'change'],
        },
      ],
      changeFun: (e) => {},
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'followMedicalPractive',
      model: 'followMedicalPractive',
      spanNum: 24,
      label: '遵医行为：',
      options: [
        { label: '良好', value: '良好' },
        { label: '一般', value: '一般' },
        { label: '差', value: '差' },
      ],
      rules: [
        {
          required: true,
          message: '请选择遵医行为情况',
          trigger: ['submit', 'change'],
        },
      ],
      changeFun: (e) => {},
    },
  ]
}
