import { checkMobile } from '@/utils/followup/followupUtils/checkField'

export default ($this) => {
  return [
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'medicationObedience',
      model: 'medicationObedience',
      label: '服药依从性：',
      disabled: false,
      spanNum: 24,
      options: [
        { label: '规律', value: '规律', disabled: false },
        { label: '间断', value: '间断', disabled: false },
        { label: '不服药', value: '不服药', disabled: false },
      ],
      rules: [
        {
          required: true,
          message: '请选择服药依从性',
          trigger: ['submit', 'change'],
        },
      ],
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'medicalSideEffects',
      model: 'medicalSideEffects',
      label: '药物不良反应：',
      disabled: false,
      spanNum: 24,
      options: [
        { label: '无', value: '无', disabled: false },
        { label: '有', value: '有', disabled: false },
      ],
      rules: [
        {
          required: true,
          message: '请选择有无不良反应',
          trigger: ['submit', 'change'],
        },
      ],
    },
    {
      formType: 'input',
      className: 'obj-form-title2',
      linkageRule: [{ name: 'medicalSideEffects', value: ['有'] }],
      prop: 'remark',
      model: 'remark',
      disabled: false,
      placeholder: '请输入不良反应',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      rules: [
        {
          required: true,
          message: '请输入不良反应',
          trigger: ['submit', 'change'],
        },
      ],
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'reactiveHypoglycemia',
      model: 'reactiveHypoglycemia',
      label: '低血糖反应：',
      disabled: false,
      spanNum: 24,
      options: [
        { label: '无', value: '无', disabled: false },
        { label: '偶尔', value: '偶尔', disabled: false },
        { label: '频繁', value: '频繁', disabled: false },
      ],
      rules: [
        {
          required: true,
          message: '请选择低血糖反应',
          trigger: ['submit', 'change'],
        },
      ],
    },
    {
      formType: 'radio',
      className: 'obj-form-title radio-block',
      prop: 'followUpClassification',
      model: 'followUpClassification',
      disabled: false,
      spanNum: 24,
      label: '此次履约分类：',
      options: [
        {
          label: '控制满意（血压控制满意，无其他异常）',
          value: '控制满意（血压控制满意，无其他异常）',
        },
        {
          label: '控制不满意（血压控制不满意，无其他异常）',
          value: '控制不满意（血压控制不满意，无其他异常）',
        },
        {
          label: '不良反应（存在药物不良反应）',
          value: '不良反应（存在药物不良反应）',
        },
        {
          label: '并发症（出现新的并发症或并发症出现异常）',
          value: '并发症（出现新的并发症或并发症出现异常）',
        },
      ],
      rules: [
        {
          required: true,
          message: '请选择此次履约分类',
          trigger: ['submit', 'change'],
        },
      ],
      changeFun: (e) => {},
    },
  ]
}
