export function dustributeOption(legendData, seriesData) {
  let option = {
    title: {
      text: "",
      x: "left"
    },
    tooltip: {
      trigger: "item",
      formatter: "{b} : {d}%"
    },
    label: {
      formatter: "{d}%"
    },
    color: ['#FF9A4B', '#FFBC3D', '#39AF9A', '#3BA0FF', '#5D7092'],
    legend: {
      orient: "horizontal",
      top: "",
      left: "0%",
      data: legendData
    },
    series: [
      {
        name: "",
        type: "pie",
        radius: "60%",
        center: ["50%", "50%"],
        data: seriesData,
        itemStyle: {
          emphasis: {
            shadowBlur: 10,
            shadowOffsetX: 0,
            shadowColor: "rgba(0, 0, 0, 0.5)"
          }
        }
      }
    ]
  };
  return option;
}
export function recordOption(legendData, xAxisData, seriesData) {
  let option = {
    title: {
      text: "",
      x: "left"
    },
    tooltip: {
      trigger: "axis",
      axisPointer: {
        // 坐标轴指示器，坐标轴触发有效
        type: "shadow", // 默认为直线，可选为：'line' | 'shadow'
        shadowStyle: {
          shadowColor: '#E3EFED',
          width: 36,
        },
      },
      backgroundColor: 'rgba(0,0,0,0.7)',
      formatter: function (params) {
        let relVal = params[0].name + "人数：";
        let value = 0;
        for (let i = 0, l = params.length; i < l; i++) {
          value += params[i].value;
        }
        relVal += value + "人";
        let divList = [];
        divList[0] = "<div style='background: #3BA0FF;height: 12px;width: 20px;margin: 5px 5px 0 2px;float: left;border-radius:2px;'></div>";
        divList[1] = "<div style='background: #FF9A4B;height: 12px;width: 20px;margin: 5px 5px 0 2px;float: left;border-radius:2px;'></div>";
        divList[2] = "<div style='background: #FFB01B;height: 12px;width: 20px;margin: 5px 5px 0 2px;float: left;border-radius:2px;'></div>";
        divList[3] = "<div style='background: #39AF9A;height: 12px;width: 20px;margin: 5px 5px 0 2px;float: left;border-radius:2px;'></div>";
        divList[4] = "<div style='background: #5D7092;height: 12px;width: 20px;margin: 5px 5px 0 2px;float: left;border-radius:2px;'></div>";
        for (let j = params.length - 1; j >= 0; j--) {
          relVal +=
            "<br/>" + divList[j] +
            params[j].seriesName +
            "占比： " +
            (
              (100 * parseFloat(params[j].value)) /
              parseFloat(value)
            ).toFixed(2) +
            "%";
        }
        return relVal;
      }
    },
    color: ['#3BA0FF', '#FF9A4B', '#FFB01B', '#39AF9A', '#5D7092'],
    legend: {
      data: legendData,
    },
    grid: {
      left: "3%",
      right: "4%",
      bottom: "3%",
      containLabel: true
    },
    xAxis: {
      type: "category",
      data: xAxisData,
      axisLine: { //隐藏轴线
        show: false
      },
      axisTick: { // 隐藏刻度
        show: false
      },
    },
    yAxis: {
      type: "value",
      name: "人数 (个)",
      axisLine: { //隐藏轴线
        show: false
      },
      axisTick: { // 隐藏刻度
        show: false
      },
    },
    series: seriesData,
  };
  return option;
}
export function certificateOption(xAxisData, seriesJoin, seriesCert, seriesRate) {
  let option = {
    title: {
      text: "",
      x: "left"
    },
    tooltip: {
      trigger: "axis",
      axisPointer: {
        type: "cross",
        crossStyle: {
          color: "#999"
        }
      },
      backgroundColor: 'rgba(0,0,0,0.7)',
      formatter: function (params) {
        let relVal = "";
        let divList = [];
        divList[0] = "<div style='background: #5D7092;height: 12px;width: 20px;margin: 5px 5px 0 2px;float: left;border-radius:2px;'></div>";
        divList[1] = "<div style='background: #FFB01B;height: 12px;width: 20px;margin: 5px 5px 0 2px;float: left;border-radius:2px;'></div>";
        divList[2] = "<div style='background: #559A99;height: 12px;width: 12px;margin: 5px 5px 0 5px;float: left;border-radius:50%;'></div>";
        for (let j = 0, l = params.length; j < l; j++) {
          relVal += divList[j] + params[j].seriesName + "： " + params[j].value;
          if (j === 2) {
            relVal += "%";
          } else {
            relVal += "<br/>";
          }
        }
        return relVal;
      }
    },
    color: ['#5D7092', '#FFB01B', '#559A99'],
    dataZoom: {
      show: true,
      start: 0,
      end: 100
    },
    legend: {
      data: ["参与人数", "获证人数", "获证比例"]
    },
    xAxis: [
      {
        axisLabel: {
          interval: 0,
          rotate: 45
        },
        type: "category",
        data: xAxisData,
        axisPointer: {
          type: "shadow"
        },
        axisLine: { //隐藏轴线
          show: false
        },
        axisTick: { // 隐藏刻度
          show: false
        },
      }
    ],
    yAxis: [
      {
        type: "value",
        name: "人数（个）",
        axisLabel: {
          formatter: "{value} "
        },
        axisLine: { //隐藏轴线
          show: false
        },
        axisTick: { // 隐藏刻度
          show: false
        },
      },
      {
        type: "value",
        name: "比例",
        min: 0,
        max: 100,
        show: false,
        axisLabel: {
          formatter: "{value} %"
        },
        axisLine: { //隐藏轴线
          show: false
        },
        axisTick: { // 隐藏刻度
          show: false
        },
        splitLine: {
          show: false
        }
      }
    ],
    series: [
      {
        name: "参与人数",
        barWidth: 10,
        type: "bar",
        data: seriesJoin,
        label: {
          show: true,
          position: "top",
          formatter: "{c}", //这是关键，在需要的地方加上就行了
          rotate: -90,
          offset: [-5, -15]
        }
      },
      {
        name: "获证人数",
        barWidth: 10,
        type: "bar",
        data: seriesCert,
        label: {
          show: true,
          position: "top",
          formatter: "{c}", //这是关键，在需要的地方加上就行了
          rotate: -90,
          offset: [-5, -15]
        }
      },
      {
        name: "获证比例",
        type: "line",
        yAxisIndex: 1,
        data: seriesRate,
        label: {
          show: true,
          position: "top",
          formatter: "{c}%" //这是关键，在需要的地方加上就行了
        }
      }
    ]
  };
  return option;
}
export function durationOption(xAxisData, seriesData) {
  let option = {
    title: {
      text: "",
      x: "left"
    },
    tooltip: {
      trigger: "axis",
      axisPointer: {
        type: "shadow" // 默认为直线，可选为：'line' | 'shadow'
      }
    },
    color: ['#449284'],
    grid: {
      left: "3%",
      right: "4%",
      bottom: "3%",
      containLabel: true
    },
    dataZoom: {
      show: true,
      start: 0,
      end: 100
    },
    xAxis: [
      {
        axisLabel: {
          interval: 0,
          rotate: 35
        },
        type: "category",
        data: xAxisData,
        axisTick: {
          alignWithLabel: true
        }
      }
    ],
    yAxis: [
      {
        type: "value",
        name: "完成时长 (天)"
      }
    ],
    series: [
      {
        name: "时长",
        type: "bar",
        barWidth: 18,
        data: seriesData,
        label: {
          show: true,
          position: "top",
          formatter: "{c}", //这是关键，在需要的地方加上就行了
          rotate: -90,
          offset: [-5, -17]
        }
      }
    ]
  };
  return option;
}

export function educationEffect(xAxisData, seriesBefore, seriesAfter) {
  let option = {
    title: {
      text: ""
    },
    tooltip: {
      trigger: "axis",
      axisPointer: {
        type: "shadow"
      },
      formatter: function (params) {
        let relVal = params[0].name + "";
        let value = 0;
        relVal += value + "";
        let divList = [];
        divList[0] = "<div style='background: #5D7092;height: 12px;width: 20px;margin: 5px 5px 0 2px;float: left;border-radius:2px;'></div>";
        divList[1] = "<div style='background: #FFB01B;height: 12px;width: 20px;margin: 5px 5px 0 2px;float: left;border-radius:2px;'></div>";
        for (let j = 0; j <= params.length - 1; j++) {
          relVal +=
            "<br/>" + divList[j] +
            params[j].seriesName +
            "： " + params[j].value + "%";
        }
        return relVal;
      }
    },
    color: ["#FEBB3C", "#39AF9A"],
    legend: {
      data: ["项目前总正确率", "项目后总正确率"]
    },
    grid: {
      left: "3%",
      right: "4%",
      bottom: "3%",
      containLabel: true
    },
    xAxis: {
      type: "category",
      data: xAxisData,
      axisLine: { //隐藏轴线
        show: false
      },
      axisTick: { // 隐藏刻度
        show: false
      },
    },
    yAxis: {
      min: 0,
      max: 100,
      type: "value",
      axisLabel: {
        formatter: "{value} %"
      },
      axisLine: { //隐藏轴线
        show: false
      },
      axisTick: { // 隐藏刻度
        show: false
      },
    },
    series: [
      {
        name: "项目前总正确率",
        type: "bar",
        barWidth: 18,
        data: seriesBefore,
        label: {
          show: true,
          position: "top",
          formatter: "{c}%",
          rotate: -90,
          offset: [-5, -17]
        }
      },
      {
        name: "项目后总正确率",
        type: "bar",
        barWidth: 18,
        data: seriesAfter,
        label: {
          show: true,
          position: "top",
          formatter: "{c}%",
          rotate: -90,
          offset: [-5, -17]
        }
      }
    ]
  };
  return option;
}

export function knowledgeEffect(xAxisData, seriesBefore, seriesAfter) {
  let option = {
    title: {
      text: ""
    },
    tooltip: {
      trigger: "axis",
      axisPointer: {
        type: "shadow"
      },
      formatter: function (params) {
        let relVal = params[0].name + "";
        let value = 0;
        relVal += value + "";
        let divList = [];
        divList[0] = "<div style='background: #5D7092;height: 12px;width: 20px;margin: 5px 5px 0 2px;float: left;border-radius:2px;'></div>";
        divList[1] = "<div style='background: #FFB01B;height: 12px;width: 20px;margin: 5px 5px 0 2px;float: left;border-radius:2px;'></div>";
        for (let j = 0; j <= params.length - 1; j++) {
          relVal +=
            "<br/>" + divList[j] +
            params[j].seriesName +
            "： " + params[j].value + "%";
        }
        return relVal;
      }
    },
    color: ["#FFB01B", "#5D7092"],
    dataZoom: {
      show: true,
      start: 0,
      end: 100
    },
    legend: {
      data: ["培训前正确率", "培训后正确率"]
    },
    grid: {
      left: "3%",
      right: "4%",
      bottom: "3%",
      containLabel: true
    },
    xAxis: {
      axisLabel: {
        interval: 0,
        rotate: 45
      },
      axisLine: { //隐藏轴线
        show: false
      },
      axisTick: { // 隐藏刻度
        show: false
      },
      type: "category",
      data: xAxisData,
    },
    yAxis: {
      min: 0,
      max: 100,
      type: "value",
      axisLine: { //隐藏轴线
        show: false
      },
      axisTick: { // 隐藏刻度
        show: false
      },
      axisLabel: {
        formatter: "{value} %"
      }
    },
    series: [
      {
        name: "培训前正确率",
        type: "bar",
        barWidth: 18,
        data: seriesBefore,
        label: {
          show: true,
          position: "top",
          formatter: "{c}%", //这是关键，在需要的地方加上就行了
          rotate: -90,
          offset: [-5, -17]
        },
      },
      {
        name: "培训后正确率",
        type: "bar",
        barWidth: 18,
        data: seriesAfter,
        label: {
          show: true,
          position: "top",
          formatter: "{c}%", //这是关键，在需要的地方加上就行了
          rotate: -90,
          offset: [-5, -17]
        }
      }
    ]
  };
  return option;
}

export function examTimes(xAxisData, seriesData) {
  let option = {
    title: {
      text: "",
      x: "left"
    },
    tooltip: {
      trigger: "axis",
      axisPointer: {
        type: "shadow" // 默认为直线，可选为：'line' | 'shadow'
      }
    },
    color: ['#449284'],
    grid: {
      left: "3%",
      right: "4%",
      bottom: "3%",
      containLabel: true
    },
    dataZoom: {
      show: true,
      start: 0,
      end: 100
    },
    xAxis: [
      {
        // splitLine: {
        //   show: false
        // },
        axisLabel: {
          interval: 0,
        },
        type: "category",
        data: xAxisData,
        axisTick: {
          alignWithLabel: true
        }
      }
    ],
    yAxis: [
      {
        splitLine: {
          show: true
        },
        type: "value",
        name: "人数 (名)"
      }
    ],
    series: [
      {
        name: "",
        type: "bar",
        barWidth: 17,
        data: seriesData,
        label: {
          show: true,
          position: "top",
          formatter: "{c}",
          rotate: -90,
          offset: [-5, -15],
        }
      }
    ]
  };
  return option;
}

export function examScore(xAxisData, seriesData) {
  let option = {
    title: {
      text: "",
      x: "left"
    },
    tooltip: {
      trigger: "axis",
      axisPointer: {
        type: "shadow" // 默认为直线，可选为：'line' | 'shadow'
      }
    },
    color: ['#CAA861'],
    grid: {
      left: "3%",
      right: "4%",
      bottom: "3%",
      containLabel: true
    },
    dataZoom: {
      show: true,
      start: 0,
      end: 100
    },
    xAxis: [
      {
        // splitLine: {
        //   show: false
        // },
        axisLabel: {
          interval: 0,
        },
        type: "category",
        data: xAxisData,
        axisTick: {
          alignWithLabel: true
        }
      }
    ],
    yAxis: [
      {
        splitLine: {
          show: true
        },
        type: "value",
        name: "人数 (名)"
      }
    ],
    series: [
      {
        name: "",
        type: "bar",
        barWidth: 17,
        data: seriesData,
        label: {
          show: true,
          position: "top",
          formatter: "{c}",
          rotate: -90,
          offset: [-5, -15],
        }
      }
    ]
  };
  return option;
}
export function ringOption(num , color) {
  let option = {
    title: {
      text: num+'%',
      x: 'center',
      y: 'center',
      textStyle: {
        fontSize: 24,
        fontWeight: 'normal',
        color: '#000000',
      },
      subtextStyle: {
        color: "#000000",
        fontWeight: 'normal'
      }
    },

    series: [{
      type: 'pie',
      radius: ['100%', '80%'],
      // silent: true,
      labelLine: {
        show: false
      },
      data: [{
        hoverOffset: 1,
        value: num,
        itemStyle: {
          color: color
        },
        label: {
          show: false
        }
      },
      {
        markArea: {
          silent: true,
        },
        value: 100 - num,
        itemStyle: {
          color: '#F0F2F5'
        },
        label: {
          show: false
        }
      }
      ]
    }]
  };
  return option;
}