import fetch from '../fetch';
import { getBaseUrl, getSaasDomain, getSaasApiDomain } from '@/utils/index'
import utils from '@/utils/followup/followupUtils';

const headers = {
  sysCode: 9,
  hospitalAuth:true
}

/*常量API*/
export const getConstants = (params) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`basic-data/constants/`),
      method: 'get',
      params: params,
      description: '获取常量',
    })
  // })
};
/*获取省市县乡列表*/
export const getProvinceList = (params) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`basic-data/position/provinces`),
      method: 'get',
      params: params,
      description: '获取省列表',
    })
  // })
};
export const getCityList = (params) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`basic-data/position/cities`),
      method: 'get',
      params: params,
      description: '获取市列表',
    })
  // })
};
export const getCountyList = (params) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`basic-data/position/counties`),
      method: 'get',
      params: params,
      description: '获取区县列表',
    })
  // })
};
export const getTownList = (params) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`basic-data/position/towns`),
      method: 'get',
      params: params,
      description: '获取乡镇列表',
    })
  // })
};
/*居民管理*/
export const getPatientList = (data) => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`healths/patients/infolist`),
      method: 'post',
      data: data,
      description: '获取居民列表',
    })
  })
};
export const getDiseasesList = (params) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`healths/patients/diseases/-1`),
      method: 'get',
      params: params,
      description: '获取所有疾病',
    })
  // })
};

// 新增居民
export const getQRCode = data => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`healths/qrcodes/get`),
      method: 'post',
      data: data,
      description: '获取二维码',
    })
  })
}

export const getUploadHistory = params => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`healths/docImpPat/import/records`),
      method: 'get',
      params: params,
      description: '获取上传历史记录',
    })
  })
}

export const refreshCode = data => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`healths/qrcodes/refresh`),
      method: 'post',
      data: data,
      description: '刷新二维码有效期',
    })
  })
}

export const getLabelsInfo = params => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`healths/qrcodes/getLabelsInfo`),
      method: 'get',
      params: params,
      description: '获取分组信息',
    })
  // })
}

export const downloadQRCode = data => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`healths/qrcodes/shareUrl`),
      method: 'post',
      data: data,
      description: '下载二维码',
    })
  })
}

export const uploadExcel = data => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers: {
        noSysCode: true,
        // hospitalAuth:true
      },
      url: getSaasDomain('web/patientManages/import'),
      method: 'post',
      data: data,
      description: '上传excel文件',
    })
  // })
}

// 分组管理
export const getLabelList = (params) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`healths/labels/`),
      method: 'get',
      params: params,
      description: '获取分组列表',
    })
  // })
}

export const createNewLabel = (data) => {
  return utils.checkAuth(()=>{
    return fetch({
      url: getBaseUrl(`healths/labels/`),
      headers: {
        "Content-Type": 'application/json',
        hospitalAuth:true
      },
      method: 'post',
      data: data,
      description: '新增分组',
    })
  })
}

export const changeLabelName = (data) => {
  return utils.checkAuth(()=>{
    return fetch({
      url: getBaseUrl(`healths/labels/`),
      headers,
      method: 'put',
      data: data,
      description: '修改分组名',
    })
  })
}

export const getLabelDetail = (labelId, params) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`healths/labels/v2/${labelId}/patients`),
      method: 'get',
      params: params,
      description: '获取分组详情',
    })
  // })
}

export const deleteCurrentLabel = (data) => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`healths/labels/`),
      method: 'delete',
      data: data,
      description: '删除分组',
    })
  })
}

export const deleteCurrentPatients = data => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`healths/labels/patients`),
      method: 'delete',
      data: data,
      description: '删除分组下的居民',
    })
  })

}

export const saveLabelsForPatient = (labelId, data) => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`healths/labels/v2/${labelId}/patients`),
      method: 'post',
      data: data,
      description: '分组中添加居民',
    })
  })

}

// 获取七牛上传token
export const getQiniuToken = (params) => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`file/image/token`),
      method: 'get',
      params: params,
    })
  })

};

// 意见反馈 getSaasApiDomain
export const submitFeedback = (data) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers: {
        noSysCode: true,
        "Content-Type": 'application/json'
      },
      url: getSaasApiDomain(`web/companys/feedback`),
      method: 'post',
      data: data,
    })
  // })

};

/*资料不全居民*/
export const getNotCompleteList = (params) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`healths/patients/uncomplate/${params.pageNo}/${params.pageSize}`),
      method: 'get',
      description: '获取资料不全居民列表',
    })
  // })

};
export const sendCompleteMessage = (data) => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`healths/patients/remind`),
      method: 'post',
      data: data,
      description: '提醒居民完善信息',
    })
  })

};
export const sendCompleteMessageList = (data) => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`healths/patients/list/remind`),
      method: 'post',
      data: data,
      description: '批量提醒居民完善信息',
    })
  })

};
export const getNotCompleteCount = (params) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`healths/patients/uncomplate/counts`),
      method: 'get',
      params: params,
      description: '获取未完善居民人数',
    })
  // })

};
export const getRedNum = (params) => {
  // 这个方法暂不做权限校验
  return fetch({
    headers,
    url: getBaseUrl(`healths/patients/uncompleted/last/counts`),
    method: 'get',
    params: params,
    description: '获取小红点数据',
  })
};
export const getPatientDetail = (patientId) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`healths/patients/${patientId}`),
      method: 'get',
      // params: params,
      description: '获取居民详情',
    })
  // })

};
export const deletePatient = (data) => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`healths/patients/batch`),
      method: 'delete',
      data: data,
      description: '删除居民',
    })
  })

};
export const getRemindPatient = (data) => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`healths/patients/remind`),
      method: 'post',
      data: data,
      description: '提醒居民绑定微信',
    })
  })

};
// 保存并新增
export const savePatientInfo = (data) => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`healths/patients/update`),
      method: 'post',
      data: data,
      description: '保存居民信息',
    })
  })

};
export const getNationsList = (params) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`resident/constants/nations`),
      method: 'get',
      params: params,
      description: '获取56个民族列表',
    })
  // })

};
export const getHealthRecordList = (data) => {
  // return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`followup/entering/health/records`),
      method: 'post',
      data: data,
      description: '健康档案记录列表',
    })
  // })

};
/*新的获取居民接口，搜索条件有变化*/
export const getPatientInfoList = (data) => {
  return utils.checkAuth(()=>{
    return fetch({
      headers,
      url: getBaseUrl(`healths/patients/v2/infolist`),
      method: 'post',
      data: data,
      description: '获取居民列表',
    })
  })

};


// 添加诊断：获取常用诊断列表
export const getCommonDiagnoseList = params => {
  return fetch({
    headers,
    url: getBaseUrl(`medicineDictionary/icdCommonDiagnosis`),
    method: 'get',
    params: params,
    description: '获取常用诊断列表',
  })
}

// 添加诊断：搜索
export const goToSearch = params => {
  return fetch({
    headers,
    url: getBaseUrl(`medicineDictionary/icdContents`),
    method: 'get',
    params: params,
    description: '常用诊断搜索',
  })
}

// 选择或搜索诊断
export const getIcdList = params => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/icd/list`),
    // url: 'http://sosoapi.yunqueyi.com/sosoapi-web/pass/mock/46/healths/icd/list',
    method: 'get',
    params: params,
    description: '选择或搜索诊断',
  })
}

//手动添加埋点
export const postTrace = (actionName, viewPath) => {
  let para = {
    "datas": [
      {
        "pseudo_session": "",
        "pseudo_id": "",
        "class_name": "test-compontens",
        "action": actionName, //"ACTION_WEB_ENTER"
        "view_path": viewPath,//"http://10.177.11.248:8080/"
        "created": new Date().getTime(),//"1568685179301"
        "user_token": "",
        "mobile": "",
        "doctor_id": "",
        "device_brand": "",
        "device_model": "",
        "app_version": "",
        "device_type": "1",
        "device_ip": "",
        "web_data": {

        },
        "alternate_info": "",
        "extra_info": "",
        "web_data_type": "2"
      }
    ]
  }
  return fetch({
    headers,
    url: getBaseUrl(`file/log/trace1`),
    method: 'post',
    data: para,
    description: '手动添加埋点',
  })
}

export const getCircleRole = (params) => {
  // return utils.checkAuth(()=>{
  return fetch({
    headers: {
      token: localStorage.getItem('storageToken')
    },
    url: getBaseUrl(`circle/circle/user/auth`),
    method: 'get',
    params: params,
    description: '获取圈子展示权限',
  })
  // })

};
