#!/bin/bash
hasGit=`which git` # 判断是否存在git
msg=${1:-'auto commit'} # 获取终端输入的第一个参数，若为空则为auto commit
if [ ! $hasGit ];then
  echo 'Please download git first!';
  exit 1;
else
  result=`git symbolic-ref --short -q HEAD` # 获取分支名
  curBranch=${result} # 去除多余的*
  echo `你的当前分支是:$curBranch`
  git add .
  git commit -m "$msg"
  git push origin $curBranch # 提交代码到github(修改了远程项目名)
fi
