import rangeJson from './rangConfig';

// 这个方法，是用户在选择随访轮次（6个月，12个月）后续操作
let checkNeedRule = (val) => {
  const needRule = sessionStorage.getItem('needRule');
  if( val!='0' && (!val||val=='') && (!needRule || needRule=='true') ){
    return true;
  }
  return false;
}

// 校验范围通用方法
export const checkRange = (rule, value, callback) => {
  let min,max;
  let val = parseFloat(value);
  let res;
  // 处理 诸如 01 这种情况
  if(value.length>1 && value.indexOf('.')<0){
    res = (new RegExp(/^[1-9]\d*$/g)).test(value);
  }else{
    res = true;
  }

  rangeJson.forEach((item)=>{
    if(item.field == rule.field){
      min = item.min;
      max = item.max;
    }
  })
  const ruless = ( (val >= min) && (val <= max) && res )
  if(ruless || checkNeedRule(val)){
    callback()
  }else{
    callback(new Error(`输入范围${min}~${max}`))
  }
}

// 校验手机号
export const checkMobile = (rule, value, callback) => {
  const reg = /^1[3|4|5|7|8|9][0-9]{9}$/; //验证规则
  const flag = reg.test(value);
  if(flag){
    callback()
  }else{
    callback(new Error(`请输入正确的手机号码`))
  }
}

// 校验是否是整数
export const checkIsInteger = (rule, value, callback) => {
  const val = parseFloat(value);
  const num = Number.isInteger(val);

  // const val = Number.parseInt(value);
  // const num =  /^[0-9]*[1-9][0-9]*$/.test(value);
  if(num || checkNeedRule(val)){
    callback()
  }else{
    callback(new Error(`输入整数`))
  }
}

// 校验是否是一位小数
export const checkNumberIsToFixed = (rule, value, callback) => {
  const isNum = /^(([1-9][0-9]*)|(([0]\.\d{1,1}|[1-9][0-9]*\.\d{1,1})))$/;
  const val = Number(value);
  if(isNum.test(val)  || checkNeedRule(val)){
    callback()
  }else{
    callback(new Error(`最多输入1位小数`))
  }
}

// 大于0的正整数
export const checkNormalInt = (rule, value, callback) => {
  const val = parseFloat(value);
  const isInteger = Number.isInteger(val);
  if((isInteger && val > 0) || checkNeedRule(val)){
    callback()
  }else{
    callback(new Error(`请输入大于0的正整数`))
  }
}

// 校验是否是两位小数
export const checkNumberIsToFixedTwo = (rule, value, callback) => {
  const isNum = /^(-)?(0|[1-9]\d*)(\s|$|\.\d{1,2}\b)/;
  const val = Number(value);
  if(isNum.test(val)  || checkNeedRule(val)){
    callback()
  }else{
    callback(new Error(`最多输入2位小数`))
  }
}
