export default [
  {
    formType: 'radio',
    // className: 'clear-left',
    prop: 'a1',
    model: 'a1',
    spanNum: 24,
    label: '调查时状态',
    options: [
      { label: '接受调查', value: '1' },
      { label: '失访', value: '2' },
      { label: '死亡', value: '3' }
      ],
    rules: [{ required: true, message: '请选择调查时状态', trigger: 'blur' }]
  },

  {
    formType: 'radio',
    prop: 'a7',
    model: 'a7',
    label: '调查方式',
    linkageRule: [{ name: 'a1', value: ['1'] }],
    disabled: false,
    placeholder: '150',
    spanNum: 24,
    options: [
      { label: '面对面', value: '1', disabled: false },
      { label: '电话（限中危人群，高危人群6个月随访）', value: '2', disabled: false },
    ],
    rules: [{ required: true, message: '请选择调查方式', trigger: 'blur' }]
  },
  {
    formType: 'radio',
    prop: 'a8',
    model: 'a8',
    label: '本次调查是否为被调查者本人',
    linkageRule: [{ name: 'a1', value: ['1'] }],
    disabled: false,
    placeholder: '150',
    spanNum: 24,
    options: [
      { label: '是', value: '1', disabled: false },
      { label: '否', value: '2', disabled: false },
    ],
    rules: [{ required: true, message: '请选择是否', trigger: 'blur' }]
  },
  {
    formType: 'radio',
    prop: 'a9',
    model: 'a9',
    label: '提供信息者与被调查者之间关系',
    linkageRule: [{ name: 'a8', value: ['2'] }],
    disabled: false,
    placeholder: '150',
    spanNum: 24,
    options: [
      { label: '父母', value: '1', disabled: false },
      { label: '配偶', value: '2', disabled: false },
      { label: '子女', value: '3', disabled: false },
      { label: '兄弟姐妹', value: '4', disabled: false },
      { label: '其他', value: '5', disabled: false },
    ],
    rules: [{ required: true, message: '请选择是否', trigger: 'blur' }]
  },
  {
    formType: 'input',
    linkageRule: [{name: 'a9',value: ['5']}],
    prop: 'a10',
    model: 'a10',
    label: '其他',
    disabled: false,
    placeholder: '请输入其他原因',
    spanNum: 12,
    type: 'number',
    labmsg: '',
    // slots: [{ name: 'mmol/L', type: 'append' }]
  },

  {
    formType: 'radio',
    // className: 'clear-left',
    prop: 'a2',
    model: 'a2',
    spanNum: 24,
    label: '失访原因',
    linkageRule: [{ name: 'a1', value: ['2'] }],
    options: [
      { label: '失去联系', value: '1' },
      { label: '拒绝参加调查', value: '2' },
      { label: '其他', value: '3' }
    ],
    rules: [{ required: true, message: '请选择失访原因', trigger: 'blur' }]
  },
  {
    formType: 'input',
    linkageRule: [{name: 'a2',value: ['3']}],
    prop: 'a3',
    model: 'a3',
    label: '其他',
    disabled: false,
    placeholder: '请输入其他原因',
    spanNum: 12,
    type: 'number',
    labmsg: '',
    // slots: [{ name: 'mmol/L', type: 'append' }]
  },


  {
    formType: 'date-picker',
    prop: 'a4',
    model: 'a4',
    placeholder: '选择死亡时间',
    label: '死亡时间',
    linkageRule: [{ name: 'a1', value: ['3'] }],
    format: 'yyyy-MM-dd',
    type: 'date',
    rules: [{ required: true, message: '请选择死亡时间', trigger: 'blur' }]
  },
  {
    formType: 'radio',
    prop: 'a5',
    model: 'a5',
    label: '死亡原因',
    linkageRule: [{ name: 'a1', value: ['3'] }],
    disabled: false,
    placeholder: '150',
    spanNum: 24,
    options: [
      { label: '脑卒中', value: '1', disabled: false },
      { label: '冠心病', value: '2', disabled: false },
      { label: '恶心肿瘤', value: '3', disabled: false },
      { label: '呼吸系统疾病', value: '4', disabled: false },
      { label: '损伤和中毒', value: '5', disabled: false },
      { label: '不祥', value: '6', disabled: false },
      { label: '其他', value: '7', disabled: false },
    ],
    rules: [{ required: true, message: '请选择死亡原因', trigger: 'blur' }]
  },
  {
    formType: 'radio',
    prop: 'a6',
    model: 'a6',
    label: '脑卒中类型',
    linkageRule: [{ name: 'a5', value: ['1'] }],
    disabled: false,
    placeholder: '150',
    spanNum: 24,
    options: [
      { label: '出血性脑卒中', value: '1', disabled: false },
      { label: '缺血性脑卒中', value: '2', disabled: false },
      { label: '不祥', value: '3', disabled: false },
    ],
    rules: [{ required: true, message: '请选择脑卒中类型', trigger: 'blur' }]
  },
]
