import axios from '../fetch';

import utils from './followupUtils';

// 随访接口域名
let domain = ' ';
if (process.env.APIDOMAIN === 'prod') {
  domain = ' ';
} else if (process.env.APIDOMAIN === 'test') {
  domain = ' ';
} else if (process.env.APIDOMAIN === 'uat') {
  domain = ' ';
} else if (process.env.APIDOMAIN === 'dev') {
  domain = ' ';
}


/*计划管理API*/
const  planManageApi = [
  {
    url: '/followup/planPatient',
    method: 'GET',
    params: 'params',
    name: 'getResidentList',
    description: '获取居民列表',
  },
]




const api = {};
const apis = [...planManageApi];

apis.forEach(item => api[item.name] = (params = {}, extraConfig = {}) => {
  const config = {
    baseURL: domain,
    url: item.url,
    method: item.method,
  };
  if (extraConfig.urlSuffix) { // 需要做URL拼接的情况(比如*.do/2),,,可以根据自己的实际情况进行扩展
    config.url = `${config.url}${extraConfig.urlSuffix}`;
    //something else
  }
  const filterParams = utils.DC.getParams(params, item.args);
  if (item.params === 'data') {
    config.data = filterParams;
  } else {
    config.params = filterParams;
  }
  /*utils.MSG.$emit('axios:begin', item.url);*/
  return axios({
    ...config,
    ...extraConfig,
  }).then(res => {
    return Promise.resolve(res);
  }).catch(err => {
    return Promise.resolve({ // 请务必根据data判断
      data: {
        code: 222222, // exception 专用
        msg: 'axios:error',
        err,
        message: err
      },
    });
  });
});

export default api;
