import "@babel/polyfill";
import Vue from 'vue'
import VueRouter from 'vue-router'
import routes from './router/router'
import store from './store/'
const mixins = require('@/utils/mixins');
import '@/utils/rem'					// 引入自适应
import '@/utils/yqyServerRegister'		// 移动端服务
import FastClick from 'fastclick'
// import Logger from './plugins/logger' 	// 日志插件
import Swiper from './plugins/swiper.min.js' 	// 日志插件

// 引入Mint
import Mint from 'mint-ui'
import 'mint-ui/lib/style.css'

import VueLazyload from 'vue-lazyload'

// var fundebug = require("fundebug-javascript");
// fundebug.apikey = "2314c71dd8580325f1419f767fd5b14e734e4343ad8e029e784e023abc0de0c2";

//
// function formatComponentName(vm) {
//     if (vm.$root === vm) return 'root';
//     var name = vm._isVue
//         ? (vm.$options && vm.$options.name) ||
//           (vm.$options && vm.$options._componentTag)
//         : vm.name;
//     return (
//         (name ? 'component <' + name + '>' : 'anonymous component') +
//         (vm._isVue && vm.$options && vm.$options.__file
//             ? ' at ' + (vm.$options && vm.$options.__file)
//             : '')
//     );
// }
// Vue.config.errorHandler = function(err, vm, info) {
//     if (vm) {
//         var componentName = formatComponentName(vm);
//         var propsData = vm.$options && vm.$options.propsData;
//         fundebug.notifyError(err, {
//             metaData: {
//                 componentName: componentName,
//                 propsData: propsData,
//                 info: info
//             }
//         });
//     } else {
//         fundebug.notifyError(err);
//     }
// };

Vue.use(VueLazyload, {
	preLoad: 3,
	// loading: require('./images/change.png'),
	error: require('./images/error.png'),
	attempt: 1
	// lazyComponent: true
})

Vue.config.devtools = true;
Vue.use(Mint)
// Vue.use(Logger, { prefix: new Date(), isDev: process.env.NODE_ENV === 'development', cLevel: 'debug' })

if ('addEventListener' in document) {
    document.addEventListener('DOMContentLoaded', function() {
        FastClick.attach(document.body);
    }, false);
}

Vue.use(VueRouter)
const router = new VueRouter({
	routes,
	mode: 'hash',
	strict: process.env.NODE_ENV !== 'production',
	scrollBehavior (to, from, savedPosition) {
	    if (savedPosition) {
		    return savedPosition
		} else {
			if (from.meta.keepAlive) {
				from.meta.savedPosition = document.body.scrollTop;
			}
		    return { x: 0, y: to.meta.savedPosition || 0 }
		}
	}
})

// 加入混合
Vue.mixin({
	...mixins
})
// setTimeout(() => {
//     new Vue({
//         router,
//         store,
//     }).$mount('#app') 
// }, 10000);

new Vue({
	router,
	store,
}).$mount('#app')

