//求并集
export function getUnion(a, b) {
  if (a.constructor === Array && b.constructor === Array) {
    let set1 = new Set(a);
    let set2 = new Set(b);
    return Array.from(new Set([...set1, ...set2]));
  }
  return null;
}
//求差集
export function getDifference(a, b) {
  if (a.constructor === Array && b.constructor === Array) {
    let set1 = new Set(a);
    let set2 = new Set(b);
    return Array.from(new Set([...set1].filter(x => !set2.has(x))));
  }
  return null;
}
//求交集
export function getIntersect(a, b) {
  if (a.constructor === Array && b.constructor === Array) {
    let set1 = new Set(a);
    let set2 = new Set(b);
    return Array.from(new Set([...set1].filter(x => set2.has(x))));
  }
  return null;
}
//获取id的list
export function getIdList(data) {
  let list = [];
  if (typeof data === 'undefined') {
    return list;
  }
  if (data.constructor === Array) {
    for (let i = 0; i < data.length; i++) {
      list.push(data[i].id);
    }
  }
  return list;
}
//区域
export function getDivision(data) {
  if (data === null || data == 'NaN') {
    let empty = [];
    return empty;
  }
  let list = data.split('|');
  let num = [];
  for (let i = 0; i < list.length; i++) {
    num[i] = parseInt(list[i]);
  }
  //console.log(list);
  return num;
}
export function getLevelList(data) {
  let level = [];
  level[0] = {
    id: '-1',
    label: '全部医院等级',
  }
  for (let i = 0; i < data.length; i++) {
    let obj = {
      id: data[i].no,
      label: data[i].value,
    }
    level.push(obj);
  }
  //console.log(level);
  return level;
}
function inTags(id, tags) {
  let flag = false;
  for (let i = 0; i < tags.length; i++) {
    if (tags[i].key == id) {
      flag = true;
    }
  }
  return flag;
}
export function inOrganization(list, id) {
  let flag = false;
  if (list.length == 0) {
    flag = true;
  }
  for (let i = 0; i < list.length; i++) {
    if (list[i].id != id) {
      flag = true;
    }
  }
  return flag;
}
export function initTags(value) {
  let tags = [];
  for (let j = 0; j < value.length; j++) {
    let tagsComponent = {};
    tagsComponent.value = value.value;
    tagsComponent[j].name = this.optionsComponent[j].label;
  }
  return tags;
}
//机构列表
export function getOrganizationList(data) {
  let list = [];
  list[0] = {
    value: '0',
    label: '全部机构',
  };
  for (let i = 0; i < data.length; i++) {
    let obj = {
      value: data[i].key,
      label: data[i].name,
    }
    list.push(obj);
  }
  return list;
}
//机构列表
export function getHospitalList(data) {
  let list = [];
  list[0] = {
    value: 0,
    label: '全部医院',
  };
  for (let i = 0; i < data.length; i++) {
    let obj = {
      value: data[i].id,
      label: data[i].name,
    }
    list.push(obj);
  }
  //console.log(list);
  return list;
}

//拼树
export function changeTags(option) {
  let list = [];
  // for(let i=0;i<option.length;i++) {
  //   console.log(option[i].label);
  //   let obj = {
  //     name: option[i].name,
  //     key: option[i].key,
  //   }
  //   list.push(obj);
  // }
  console.log(option);
  return option;
}
// 递归删除多余的节点
function handlerAction(treeData, selData) {
  treeData.forEach((elem, index) => {
    if (!isValuable(elem.value, selData)) {
      treeData.splice(index, 1)
      handlerAction(treeData, selData)
    } else {
      if (elem.children) {
        handlerAction(elem.children, selData)
      }
    }
  })
  return treeData;
}
function isValuable(val, selData) {
  for (let i = 0; i < selData.length; i++) {
    if (selData[i]['value'].indexOf(val) >= 0) {
      return true
    }
  }
  return false
}
function changeTreeKey(oData, orgKey, targetKey) {
  oData = [...oData]
  oData.forEach(elem => {
    elem[targetKey] = elem[orgKey]
    delete elem[orgKey]
    if (elem.children) {
      changeTreeKey(elem.children, orgKey, targetKey)
    }
  })
  return oData
}
function deleteTreeKey(oData, delKeys) {
  oData = [...oData]
  oData.forEach(elem => {
    delKeys.forEach(key => {
      delete elem[key]
    })
    if (elem.children) {
      deleteTreeKey(elem.children, delKeys)
    }
  })
  return oData
}
function deleteEmptyChild(oData) {
  oData = [...oData]
  oData.forEach(elem => {
    if (elem.children && elem.children.length == 0) {
      delete elem.children
    } else if (elem.children) {
      deleteEmptyChild(elem.children)
    }
  })
  return oData
}
function addEmpty(data) {
  let after = [];
  after[0] = {
    label: "全部地区",
    value: "0",
  }
  for (let i = 0; i < data.length; i++) {
    after.push(data[i]);
  }
  return after;
}
export function treeHandler(treeData, selData) {
  //console.log('treeData',treeData,'selData',selData);
  treeData = deleteTreeKey(treeData, ['status', 'disabled'])
  treeData = changeTreeKey(treeData, 'id', 'value')
  selData = changeTreeKey(selData, 'name', 'label')
  selData = changeTreeKey(selData, 'key', 'value')
  let endData = deleteEmptyChild(handlerAction(treeData, selData));
  // console.log(treeData, selData)
  //return handlerAction(treeData, selData);
  let returnData = addEmpty(endData);
  return returnData;
}

//小生态
export function getEcologyList() {
  let dataList = [{
    id: '123',
    name: '上海第一人民医院',
    hospitalLevelName: '二甲医院',
    provinceName: '上海市',
    cityName: '上海市',
    countyName: '浦东新区',
    townName: '--',
  }, {
    id: '124',
    name: '上海第二人民医院',
    hospitalLevelName: '二甲医院',
    provinceName: '上海市',
    cityName: '上海市',
    countyName: '浦东新区',
    townName: '--',
  }, {
    id: '125',
    name: '上海第三人民医院',
    hospitalLevelName: '二甲医院',
    provinceName: '上海市',
    cityName: '上海市',
    countyName: '浦东新区',
    townName: '--',
  }]
  return dataList;
}
export function getEcologySelect(data) {
  // let ecologyist = [{
  //   label: '上海小生态',
  //   value: '1',
  // },{
  //   label: '北京小生态',
  //   value: '2',
  // }];
  let ecologyist = [];
  for (let i = 0; i < data.length; i++) {
    let obj = {
      label: data[i].name,
      value: data[i].id,
    }
    ecologyist.push(obj);
  }
  return ecologyist;
}
export function isOverlap(startA, endA, startB, endB) {
  let maxStart = Math.max(startA, startB);
  let minEnd = Math.min(endA, endB);
  console.log('maxStart', maxStart, 'minEnd', minEnd);
  if (maxStart <= minEnd) {
    return true;
  } else {
    return false;
  }
}
export function setRegionOption(data) {
  let option = [];
  for (let i = 0; i < data.length; i++) {
    let obj = data[i];
    obj.label = data[i].provinceName;
    obj.value = data[i].provinceId;
    option.push(obj);
  }
  return option;
}
export function getRegionOption() {
  let option = [{
    value: 1,
    label: '浙江',
    children: [{
      value: 2,
      label: '杭州',
      children: [{
        value: 120115000000,
        label: '西湖区'
      }, {
        value: 5,
        label: '东湖区'
      }]
    }]
  }];
  return option;
}
export function getLearnOrganization(data) {
  if(data.length == 0) {
    let arr = [];
    return arr;
  }
  let organization = [
    {
      label: "全部",
      value: 0
    },
  ];
  for (let i = 0; i < data.length; i++) {
    let obj = {
      label: data[i].hospital_name,
      value: data[i].hospital_id,
      index: i,
    };
    organization.push(obj);
  }
  return organization;
}
export function getPicOption(title, legendData, colorData, seriesData) {
  let option = {
    title: {
      text: title,
      x: "center",
      top: "3%",
    },
    tooltip: {
      trigger: 'item',
      formatter: "{a} <br/>{b} : {c} ({d}%)"
    },
    legend: {
      orient: "vertical",
      top: "3%",
      left: "left",
      data: legendData
    },
    grid: {
      left: "30%",
      right: "0%",
      bottom: "10%",
      containLabel: true
    },
    color: colorData,
    backgroundColor: '#F3F3F3',
    series: [
      {
        name: "",
        type: "pie",
        radius: "55%",
        center: ["60%", "65%"],
        data: seriesData,
      }
    ]
  };
  return option;
}
export function getBarOption(xAxisData, seriesData) {
  let option = {
    title: {
      text: "用户年龄发布",
      x: "center",
      top: "3%",
    },
    color: ['#3398DB'],
    backgroundColor: '#F3F3F3',
    grid: {
      left: '3%',
      right: '4%',
      bottom: '3%',
      containLabel: true
    },
    xAxis: [
      {
        type: 'category',
        data: xAxisData,
        axisLabel: {
          interval: 0
        }
        // axisTick: {
        //   alignWithLabel: true
        // }
      }
    ],
    yAxis: [
      {
        type: 'value'
      }
    ],
    series: [
      {
        name: '',
        type: 'bar',
        barWidth: 30,
        data: seriesData,
      }
    ]
  };
  return option;
}
export function getRank(xAxisData, seriesData) {
  let option = {
    color: ["#1E90FF", "#32CD32"],
    title: {
      text: "排行榜",
      x: "left",
      textStyle: {
        //主标题文本样式{"fontSize": 18,"fontWeight": "bolder","color": "#333"}
        fontSize: 20,
        fontStyle: "normal",
        fontWeight: "normal",
        color: "#000"
      }
    },
    tooltip: {
      trigger: "axis",
      formatter: '{b0}<br/>{a0}: {c0}%',
      axisPointer: {
        // 坐标轴指示器，坐标轴触发有效
        type: "shadow" // 默认为直线，可选为：'line' | 'shadow'
      }
    },
    legend: {
      data: ["完成人数"],
      bottom: 0
    },
    grid: {
      left: "3%",
      right: "4%",
      bottom: "10%",
      containLabel: true
    },
    xAxis: [
      {
        type: "category",
        data: xAxisData,
      }
    ],
    yAxis: [
      {
        type: "value",
        axisLabel: {
          show: true,
          interval: 'auto',
          formatter: '{value}%'
        },
      }
    ],
    series: [
      {
        name: "完成通过率",
        type: "bar",
        stack: "完成通过率",
        barMaxWidth: "50",
        data: seriesData,
      },
      // {
      //   name: "参与人数",
      //   type: "bar",
      //   stack: "人数",
      //   barMaxWidth: "80",
      //   data: [220, 182, 191, 220, 182, 191]
      // }
    ]
  };
  return option;
}
export function getSearchType(formData,checkAll) {
  let type = 0;
  if (formData.region.length == 1 || formData.region.length == 2) {
    type = formData.region.length;
  } else if (formData.region.length == 3) {
    if (formData.organization.length == 0 || checkAll === true) {
      type = 3;
    } else {
      type = 4
    }
  }
  return type;
}
export function hasAll(data) {
  let flag = false;
  for (let i = 0; i < data.length; i++) {
    if (data[i] == 0) {
      flag = true;
      return flag
    }
  }
  return flag;
}
export function getIds(formData, organizationList, checkAll) {
  let ids = '';
  if (formData.organization.length == 0) {
    //地区id
    ids = formData.region[formData.region.length - 1];
  } else {
    //机构id 选了'全部'
    if (checkAll === true) {
      // for (let i = 0; i < organizationList.length; i++) {
      //   if (organizationList[i].value != 0) {
      //     ids += organizationList[i].value + ',';
      //   }
      // }
      ids = formData.region[formData.region.length - 1];
    } else {
      for (let i = 0; i < formData.organization.length; i++) {
        if (formData.organization[i] != 0) {
          ids += formData.organization[i] + ',';
        }
      }
      ids = ids.substring(0, ids.length - 1);
    }
  }
  return ids;
}
//获取id的list
export function getDoctorIdList(data) {
  let list = [];
  if (typeof data === 'undefined') {
    return list;
  }
  if (data.constructor === Array) {
    for (let i = 0; i < data.length; i++) {
      list.push(data[i].doctorId);
    }
  }
  return list;
}
export function getAjustmentList(data) {
  let idList = "";
  for (let i = 0; i < data.length; i++) {
    idList += data[i] + ',';
  }
  idList = idList.substring(0, idList.length - 1);
  return idList;
}
export function removeZero(data) {
  let list = [];
  for(let i = 0;i<data.length;i++) {
    if(data[i].value != 0) {
      list.push(data[i]);
    }
  }
  return list;
}
export function initRank(data) {
  let list = [{gradeFlag: -1, gradeName: "全部"}];
  for(let i=0;i<data.length;i++) {
    list.push(data[i]);
  }
  return list;
}
export function getAvgTime(data) {
  let list = [0,0];
  if(data != null && data !='') {
    list[0] = Math.floor(data / 60);
    list[1] = data % 60;
  }
  return list;
}
export function getComponent(data) {
  let list = [];
  for(let i=0;i<data.length;i++) {
    list.push(data[i].value);
  }
  return list;
}