export default ($this) => {
  return [
    {
      formType: 'div',
      name: '3.5 糖尿病',
      className: 'sec-title',
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'haveDiabetes',
      model: 'haveDiabetes',
      label: '随访期间是否新发现有糖尿病：',
      disabled: false,
      spanNum: 24,
      options: [
        { label: '否', value: '否', disabled: false },
        { label: '是', value: '是', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否', trigger: 'submit' }]
    },
    {
      formType: 'date-picker',
      className: 'obj-form-title2',
      prop: 'diagnoseTime',
      model: 'diagnoseTime',
      placeholder: '确诊时间',
      label: '确诊时间：',
      linkageRule: [{ name: 'haveDiabetes', value: ['是'] }],
      format: 'yyyy',
      valueFormat: 'yyyy',
      dateType: 'year',
      type: 'date',
      spanNum: 6,
      rules: [{ required: true, message: '确诊时间', trigger: 'submit' }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title2',
      prop: 'takeHypoglycemicDrugs',
      model: 'takeHypoglycemicDrugs',
      label: '是否服用降糖药：',
      linkageRule: [{ name: 'haveDiabetes', value: ['是'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '否', value: '否', disabled: false },
        { label: '是', value: '是', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否', trigger: 'submit' }],
      changeFun(e){
        if(e == '是') {
          $this.addComponents.forEach((item,index)=>{
            if(item.formName == 'stroke_010'){
              $this.addComponents[index].formObject = {
                ...$this.addComponents[index].formObject,
                hypoglycemicDrugsType: []
              }
            }
          })
        }
      }
    },
    {
      formType: 'checkbox',
      className: 'obj-form-title3',
      prop: 'hypoglycemicDrugsType',
      model: 'hypoglycemicDrugsType',
      label: '选择的降糖药：',
      linkageRule: [{name: 'takeHypoglycemicDrugs', value: ['是']}],
      disabled: false,
      changeFun: (val) => {
        // console.log(val)
      },
      spanNum: 24,
      options: [
        {label: '服降糖药', value: '服降糖药', disabled: false},
        {label: '胰岛素', value: '胰岛素', disabled: false},
        {label: '其他', value: '其他', disabled: false},
      ],
      rules: [{required: true, message: '请选择是否', trigger: 'submit'}]
    },
    {
      formType: 'input',
      className: 'obj-form-title3',
      linkageRule: [{name: 'hypoglycemicDrugsType',value: ['其他']}],
      prop: 'remark',
      model: 'remark',
      label: '其他降糖药：',
      disabled: false,
      placeholder: '请输入其他降糖药',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      rules: [{ required: true, message: '请输入其他降糖药', trigger: 'submit' }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title2',
      prop: 'bloodSugarControl',
      model: 'bloodSugarControl',
      label: '血糖控制情况：',
      linkageRule: [{ name: 'haveDiabetes', value: ['是'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '基本达标', value: '基本达标', disabled: false },
        { label: '未达标', value: '未达标', disabled: false },
        { label: '不清楚', value: '不清楚', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否', trigger: 'submit' }]
    },

  ]
}
