import followApi from '../../../utils/followup/followapis'

export default {
  namespaced: true,
  state: {
    residentList: { //居民列表
      pageNum: 1, //当前页码
      pageSize: 10, //每页数据大小
      total: null,  //总数
    },
    groupList: [],  //分组列表

  },
  mutations: {
    GET_RESIDENT_LIST(state, payload) {
      state.residentList = payload
    },
    GET_GROUP_LIST(state, payload) {
      state.groupList = payload.labelDtoList
    }
  },
  actions: {
    getResidentList(context, payload) {
      const { pageSize, pageNum } = context.state.residentList;
      followApi.getResidentList({
        pageSize,
        pageNum,
        ...payload
      }).then(({data}) => {
        context.commit('GET_RESIDENT_LIST', data);
      });
    },
    getGroupList(context, payload) {
      followApi.getGroupList({}).then(({data}) => {
        context.commit('GET_GROUP_LIST', data);
      });
    }
  },
}
