import App from '../App'

const login = r => require.ensure([], () => r(require('../views/login')), 'login')

const home = r => require.ensure([], () => r(require('../views/home')), 'home')
const blank = r => require.ensure([], () => r(require('../views/blank')), 'blank')
const itemManager = r => require.ensure([], () => r(require('../views/education/item-manager.vue')), 'item-manager')
const itemComponent = r => require.ensure([], () => r(require('../views/education/item-component.vue')), 'item-component')
const createComponent = r => require.ensure([], () => r(require('../views/education/create-component.vue')),'create-component')
const roleManager = r => require.ensure([], () => r(require('../views/system/role.vue')),'role')
const addManager = r => require.ensure([], () => r(require('../views/education/add-manager.vue')), 'add-manager')
const itemRole = r => require.ensure([], () => r(require('../views/system/item-role.vue')), 'item-role')
const msgPush = r => require.ensure([], () => r(require('../views/msgpush/msg-push.vue')), 'msg-push')

import patientsRouters from './patients'
import followRouters from './follow'

const reportLis = r => require.ensure([], () => r(require('../views/learning/report-list.vue')), 'report-list')
const itemList = r => require.ensure([], () => r(require('../views/learning/item-list.vue')), 'item-list')
const nameList = r => require.ensure([], () => r(require('../views/learning/name-list.vue')), 'name-list')
const dataAlignment = r => require.ensure([], () => r(require('../views/learning/data-alignment.vue')), 'data-alignment')
const exportDownload = r => require.ensure([], () => r(require('../views/learning/export-download.vue')), 'export-download')

export default [{
    path: '/',
    component: App,
    children: [
        {
          path: '/login',
          component: login,
          name: 'loginPage',
        },
        {
            path: '',
            redirect: '/home'
        },{
            path: '/index',
            component: home
        },{
            path: '/home',
            component: home
        },{
            path: '/blank',
            component: blank
        },{
            path: '/item-manager',
            component: itemManager
        },{
            path: '/add-manager',
            component: addManager
        },{
            path: '/item-component',
            component: itemComponent
        },{
            path: '/role',
            component: roleManager
        },{
            path: '/create-component',
            component: createComponent
        },{
            path: '/item-role',
            component: itemRole
        },{
            path: '/report-list',
            component: reportLis
        },{
            path: '/item-list',
            component: itemList
        },{
            path: '/data-alignment',
            component: dataAlignment
        },{
            path: '/name-list',
            component: nameList
        },
        {
            path: '/export-download',
            component: exportDownload
        },
      {
        path: '/msg-push',
        component: msgPush,
        // redirect: 'msgpush/msg-push',
      },
      // {
      //   path: '/followup',
      //   name: 'followUp',
      //   component: followUp,
      //   redirect: 'followup/plan-manage/planList',
      // },
        followRouters,
        patientsRouters,
    ]
  }]
