import fetch from '../fetch';
import { getBaseUrl } from '@/utils/index'
let headers = {
  'Content-Type': 'application/json;charset=UTF-8',
  token: localStorage.getItem('storageToken'),
};

export const saveStore = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`store/upsert`),
    method: 'post',
    data: params,
    description: '新建编辑店铺',
  })
};

export const queryStore = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`store/query`),
    method: 'post',
    data: params,
    description: '查询店铺信息',
  })
};

export const queryOrderDetail = (orderId) => {
  return fetch({
    headers,
    url: getBaseUrl(`store/orders/admin/query/${orderId}`),
    method: 'get',
    // params: params,
    description: '查询订单详情',
  })
};
///trade/order/admin/query/list
//store/orders/111/express

export const queryOrderList = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`store/orders/admin/query/list`),
    method: 'get',
    params: params,
    description: '查询订单列表',
  })
};

export const expressInfo = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`campaign/distribution/logistics/expressInfo`),
    method: 'get',
    params: params,
    description: '查询订单列表',
  })
};


export const updateExpress = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`store/orders/admin/${params.id}/express`),
    method: 'post',
    data: params,
    description: '更新物流信息',
  })
};

export const updateExpressNo = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`store/orders/admin/${params.orderId}/updateExpressNo`),
    method: 'post',
    data: params,
    description: '更新物流单号',
  })
};


export const queryShopAuth = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`store/user/storeid`),
    method: 'get',
    params: params,
    description: '查询超级管理员权限',
  })
};


export const refundApply = (params) => {
  return fetch({
    headers,
    url: getBaseUrl('trade/center/refund/apply'),
    method: 'post',
    data: params,
    description: '退货',
  })
};

// 关闭医生店铺
export const closeShop = (storeId, status = 0) => {
  return fetch({
    headers,
    url: getBaseUrl(`store/check/${storeId}/${status}`),
    method: 'put',
    data: {},
    description: '关闭医生店铺',
  })
};

export const brokerListAll = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`broker/admin/brokerListAll?ownerId=${params.ownerId}`),
    method: 'get',
    description: '云鹊店铺-订单管理-药代列表',
  })
};

export const brokerOwnerListAll = (params) => {
  return fetch({
    headers,
    url: getBaseUrl('broker/admin/brokerOwnerListAll'),
    method: 'get',
    description: '云鹊店铺-订单管理-招募人列表',
  })
};
// 获取退款说明
export const getRefundDesc = (aid) => {
  return fetch({
    headers,
    url: getBaseUrl(`/store/orders/admin/queryRefundDesc/${aid}`),
    method: 'get',
    description: '退款说明',
  })
};
