import { checkRange, checkIsInteger, checkNumberIsToFixed } from '@/utils/followup/followupUtils/checkField';

export default ($this) => {
  return [
    {
      formType: 'input',
      className: 'float-none obj-form-title',
      prop: 'helpCheck',
      model: 'helpCheck',
      disabled: false,
      label: '辅助检查：',
      placeholder: '请输入辅助检查',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      rules: [{ required: false, message: '请输入辅助检查', trigger: ['submit','change'] }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'medicationObedience',
      model: 'medicationObedience',
      spanNum: 24,
      label: '服药依从性：',
      options: [
        { label: '规律', value: '规律' },
        { label: '间断', value: '间断' },
        { label: '不服药', value: '不服药' },
      ],
      rules: [{ required: true, message: '请选择服药依从性', trigger: ['submit','change'] }],
      changeFun: (e)=>{
      }
    },

    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'medicalSideSffects',
      model: 'medicalSideSffects',
      spanNum: 24,
      label: '药物不良反应：',
      options: [
        { label: '无', value: '无' },
        { label: '有', value: '有' },
      ],
      rules: [{ required: true, message: '请选择有无药物不良反应', trigger: ['submit','change'] }],
      changeFun: (e)=>{
      }
    },
    {
      formType: 'input',
      className: 'float-none obj-form-title2',
      linkageRule: [{name: 'medicalSideSffects',value: ['有']}],
      prop: 'remark',
      model: 'remark',
      disabled: false,
      placeholder: '请输入药物不良反应',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      rules: [{ required: true, message: '请输入药物不良反应', trigger: ['submit','change'] }]
    },
  ]
}

