import { checkRange, checkIsInteger, checkNumberIsToFixed, checkNumberIsToFixedTwo } from '@/utils/followup/followupUtils/checkField';

export default ($this) => {
  let hanldeValue = () => {
    $this.addComponents.forEach((item,index)=>{
      if(item.name == 'diabetesSourseAuxiliary'){
        const glycosylatedHemoglobinPercent = item.formObject.glycosylatedHemoglobinPercent
        const glycosylatedHemoglobinDate = item.formObject.glycosylatedHemoglobinDate
        item.dataSource.forEach((item2,index2)=>{
          if((glycosylatedHemoglobinPercent||glycosylatedHemoglobinDate) && item2.refs){
            $this.addComponents[index].dataSource[index2].rules[0].required = true;
            $this.$refs['form' + index][0].validateField(['glycosylatedHemoglobinPercent','glycosylatedHemoglobinDate']);
          }else{
            if(item2.refs){
              if(item2.refs == 'glycosylatedHemoglobinPercent'){
                // $this.addComponents[index].dataSource[index2].rules[0].required = false;
                $this.addComponents[index].dataSource[index2].rules = [{ required: false, message: '请输入糖化血红蛋白值', trigger: ['submit','change'] },{ validator: checkRange , trigger: ['submit','change'] },{ validator: checkNumberIsToFixedTwo , trigger: ['submit','change'] }];
              }else{
                $this.addComponents[index].dataSource[index2].rules[0].required = false;
              }
              // $this.addComponents[index].dataSource[index2].rules[0].required = false;
              $this.$nextTick(()=>{
                $this.$refs['form'+index][0].validate((valid) => {
                });
                $this.$refs['form' + index][0].clearValidate(['fastingBloodSugar','glycosylatedHemoglobinPercent','glycosylatedHemoglobinDate']);
              })

            }
          }

        })


      }

    })
  }
  return [
    {
      formType: 'input',
      className: 'float-none',
      prop: 'fastingBloodSugar',
      model: 'fastingBloodSugar',
      disabled: false,
      label: '空腹血糖值：',
      placeholder: '请输入空腹血糖值',
      spanNum: 8,
      maxlength: 30,
      type: 'number',
      labmsg: '',
      slots: [{name: 'mmol/L', type: 'append'}],
      rules: [{ required: true, message: '请输入空腹血糖值', trigger: ['submit','change'] },{ validator: checkRange , trigger: ['submit','change'] },{ validator: checkNumberIsToFixed , trigger: ['submit','change'] }]
    },
    // {
    //   formType: 'div',
    //   name: '其他检查',
    //   className: 'sec-title',
    // },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'glycosylatedHemoglobinPercent',
      model: 'glycosylatedHemoglobinPercent',
      refs: 'glycosylatedHemoglobinPercent',
      disabled: false,
      label: '糖化血红蛋白值：',
      placeholder: '请输入糖化血红蛋白值',
      spanNum: 8,
      maxlength: 30,
      type: 'number',
      labmsg: '',
      slots: [{name: '%', type: 'append'}],
      rules: [{ required: false, message: '请输入糖化血红蛋白值', trigger: ['submit','change'] },{ validator: checkRange , trigger: ['submit','change'] },{ validator: checkNumberIsToFixedTwo , trigger: ['submit','change'] }],
      changeFun: hanldeValue,
      // blurFunc: hanldeValue
    },
    {
      formType: 'date-picker',
      className: 'float-none',
      prop: 'glycosylatedHemoglobinDate',
      model: 'glycosylatedHemoglobinDate',
      refs: 'glycosylatedHemoglobinDate',
      placeholder: '请选择',
      label: '检查日期：',
      format: 'MM 月 dd 日',
      valueFormat: 'MM-dd',
      dateType: 'date',
      type: 'date',
      rules: [{required: false, message: '请选择检查日期', trigger: ['submit','change','blur']}],
      spanNum: 12,
      changeFun: hanldeValue,
    },
  ]
}

