import fetch from '../fetch';
import { getBaseUrl, getSaasDomain, getSaasApiDomain } from '@/utils/index'
let headers = {
  'Content-Type': 'application/json;charset=UTF-8',
  token: localStorage.getItem('storageToken'),
};


export const getOnlineCircleList = () => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/v1/online/list`),
    method: 'get',
    description: '获取所有已上线的圈子列表',
  })
};

export const getActivityInfoReq = (activityId) => {
  return fetch({
  headers,
  url: getBaseUrl(`circle/sso/activity/info/${activityId}`),
  method: 'get',
  description: '后台管理--专区活动信息（查看）',
  })
  };
  export const getActivityList = (params) => {
    return fetch({
      headers,
      url: getBaseUrl(`circle/sso/activity/list`),
      method: 'get',
      params: params,
      description: '专区活动列表与搜索',
    })
  };
  export const removeActivity = (params) => {
    return fetch({
      headers,
      url: getBaseUrl(`circle/sso/activity/remove`),
      method: 'delete',
      data: params,
      description: '后台管理--专区活动删除',
    })
  };
  export const updateActivityStatus = (params) => {
    return fetch({
      headers,
      url: getBaseUrl(`circle/sso/activity/deploy`),
      method: 'post',
      data: params,
      description: '后台管理--专区活动上下线',
    })
  };


export const getActivityDocList = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/sso/activity/doctor/list`),
    method: 'get',
    params: params,
    description: '后台管理--专区活动成员列表与搜索',
  })
};


export const removeDoc = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/sso/activity/doctor/remove`),
    method: 'post',
    data: params,
    description: '后台管理--专区活动成员移除',
    withCredentials: true
  })
};

export const importDoc = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/sso/activity/doctor/import/${params.activityId}/${params.importType}`),
    method: 'post',
    data: params,
    description: '后台管理--专区活动成员导入',
  })
};

