import { checkRange, checkIsInteger, checkNumberIsToFixed } from '@/utils/followup/followupUtils/checkField';

export default ($this) => {
  return [
    {
      formType: 'input',
      className: 'float-none',
      prop: 'helpCheck',
      model: 'helpCheck',
      disabled: false,
      label: '辅助检查：',
      placeholder: '请输入辅助检查',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      rules: [{ required: false, message: '请输入辅助检查', trigger: ['submit','change'] }]
    },
    {
      formType: 'radio',
      className: 'float-none',
      prop: 'medicationObedience',
      model: 'medicationObedience',
      spanNum: 24,
      label: '服药依从性：',
      options: [
        { label: '规律', value: '规律' },
        { label: '间断', value: '间断' },
        { label: '不服药', value: '不服药' },
      ],
      rules: [{ required: true, message: '请选择服药依从性', trigger: ['submit','change'] }],
      changeFun: (e)=>{
      }
    },

    {
      formType: 'radio',
      className: 'float-none',
      prop: 'medicalSideEffects',
      model: 'medicalSideEffects',
      spanNum: 24,
      label: '药物不良反应：',
      options: [
        { label: '无', value: '无' },
        { label: '有', value: '有' },
      ],
      rules: [{ required: true, message: '请选择有无药物不良反应', trigger: ['submit','change'] }],
      changeFun: (e)=>{
      }
    },
    {
      formType: 'input',
      className: 'float-none',
      linkageRule: [{name: 'medicalSideEffects',value: ['有']}],
      prop: 'adrsMark',
      model: 'adrsMark',
      disabled: false,
      placeholder: '请输入药物不良反应',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      rules: [{ required: true, message: '请输入药物不良反应', trigger: ['submit','change'] }]
    },

    {
      formType: 'radio',
      className: 'float-none radio-block',
      prop: 'followUpClassification',
      model: 'followUpClassification',
      spanNum: 24,
      label: '此次随访分类：',
      options: [
        { label: '控制满意（血压控制满意，无其他异常）', value: '控制满意' },
        { label: '控制不满意（血压控制不满意，无其他异常）', value: '控制不满意' },
        { label: '不良反应（存在药物不良反应）', value: '不良反应' },
        { label: '并发症（出现新的并发症或并发症出现异常）', value: '并发症' },
      ],
      rules: [{ required: true, message: '请选择此次随访分类', trigger: ['submit','change'] }],
      changeFun: (e)=>{
      }
    },
  ]
}

