import fetch from '../fetch';
import { getBaseUrl } from '@/utils/index'
let headers = {
  'Content-Type': 'application/json;charset=UTF-8',
  token: localStorage.getItem('storageToken'),
};

export const moRelSearch = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/memberSelect/org/related/search`),
    method: 'post',
    data: params,
    description: '查询机构-圈子已选机构列表',
  })
};

export const morDeleteOrg = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/memberSelect/org/related/deleteOrg`),
    method: 'post',
    data: params,
    description: '删除机构- 圈子已选机构',
  })
};

export const moOption = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/memberSelect/org/option`),
    method: 'post',
    data: params,
    description: '添加机构- 勾选操作',
  })
};

export const moSave = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/memberSelect/org/save`),
    method: 'post',
    data: params,
    description: '添加机构-保存',
  })
};

export const moOrgSearch = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/memberSelect/org/search`),
    method: 'post',
    data: params,
    description: '添加机构-查询所有机构列表',
  })
};

export const clearCacheOrg = (circleId) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/memberSelect/org/option/clearCache/${circleId}`),
    method: 'get',
    description: '添加机构- 勾选操作清除缓存',
  })
};

export const mpRelSearch = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/memberSelect/people/related/search`),
    method: 'post',
    data: params,
    description: '查询人员白名单- 圈子已选人员列表',
  })
};

export const mprDeleteOrg= (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/memberSelect/people/related/deletePeople`),
    method: 'post',
    data: params,
    description: '删除人员白名单- 圈子已选人员',
  })
};

export const getprovinces = (idType) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/memberSelect/provinces/idType/${idType}`),
    method: 'get',
    description: '根据用户ID 获取选人时省市',
  })
};


