import App from '../App'
import patientsRouters from './patients'
import followRouters from './follow'

const login = () => import('../views/login');

const home = () => import('../views/home');
const blank = () => import('../views/blank');
const itemManager = () => import('../views/education/item-manager.vue');
const itemComponent = () => import('../views/education/item-component.vue');
const createComponent = () => import('../views/education/create-component.vue');
const roleManager = () => import('../views/system/role.vue');
const circleLimit = () => import('../views/system/circle-limit.vue');
const addManager = () => import('../views/education/add-manager.vue');
const editManager = () => import('../views/education/edit-manager.vue');
const itemRole = () => import('../views/system/item-role.vue');
const msgPush = () => import('../views/msgpush/msg-push.vue');
const editCme = () => import('../views/education/edit-cme.vue');
const editProfessionalExam = () => import('../views/education/edit-professional-exam.vue');
const subjectManager = () => import('../views/education/subject-manager.vue');
const editSubject = () => import('../views/education/edit-subject.vue');
const reportDownload = () => import('../views/education/report-download.vue');
const teachingPopup = () => import('../views/education/teaching-popup.vue');
const editeachPopup = () => import('../views/education/editeach-popup.vue');

const reportLisOld = () => import('../views/learning-o/report-list.vue');
const itemListOld = () => import('../views/learning-o/item-list.vue');
const nameListOld = () => import('../views/learning-o/name-list.vue');
const dataAlignmentOld = () => import('../views/learning-o/data-alignment.vue');
const exportDownloadOld = () => import('../views/learning-o/export-download.vue');

const reportLis = () => import('../views/learning/report-list.vue');
const itemList = () => import('../views/learning/item-list.vue');
const nameList = () => import('../views/learning/name-list.vue');
const dataAlignment = () => import('../views/learning/data-alignment.vue');
const exportDownload = () => import('../views/learning/export-download.vue');

const itemShield = () => import('../views/education/item-shield.vue');
const entryManager = () => import('../views/education/entry-manager.vue');
const editEntry = () => import('../views/education/edit-entry.vue');
const editNotice = () => import('../views/education/edit-notice.vue');

const creditManage = () => import('../views/cme/credit-manage.vue');
const reviewAccessManage = () => import('../views/cme/review-access-manage.vue');
const creditSendManage = () => import('../views/cme/credit-send-manage.vue');
const applyDetail =  () => import('../views/cme/apply-detail.vue');

const templateManager = () => import('../views/education/template-manager.vue');
const templateEditor = () => import('../views/education/template-editor.vue');
const templateOpen = () => import('../views/education/template-open.vue');
const eduRole = () => import('../views/education/edu-role.vue');
const editCustom = () => import('../views/education/edit-custom.vue');
const externalResourceManage = () => import('../views/education/external-resource-manage.vue');
const auditCustomCourse = () => import('../views/education/audit-custom-course.vue');
const advertSimpleManage = () => import('../views/education/advert/advert-simple-manage.vue');
const editSimpleAdvert = () => import('../views/education/advert/edit-simple-advert.vue');

const noticeEditor = () => import('../views/education/notice-editor.vue');

const activityManagement = () => import('../views/activitymanagement/activity-management.vue');
const createActivity = () => import('../views/activitymanagement/create-activity.vue');

const yqRange = () => import('../views/yqrange/yq-range.vue');
const liveManage = () => import('../views/yqrange/live-manage.vue');
const roleManage = () => import('../views/yqrange/role-manage.vue');
const createRange = () => import('../views/yqrange/create-range.vue');
const rangeManage = () => import('../views/yqrange/range-manage.vue');
const editRange = () => import('../views/yqrange/edit-range.vue');
const createLive = () => import('../views/yqrange/create-live.vue');
const blackListManage = () => import('../views/yqrange/blacklist-manage.vue');
const adminManage = () => import('../views/yqrange/admin-manage.vue');
const rangeApply = () => import('../views/yqrange/range-apply.vue');

const shopList = () => import('../views/shop/shop-list.vue');
const createShop = () => import('../views/shop/create-shop.vue');
const goodsManage = () => import('../views/goods/goods-manage.vue');
const freightConfig = () => import('../views/freight/freight-config.vue');
const createGood = () => import('../views/goods/create-good.vue');
const createGoodNew = () => import('../views/goods/create-good-new.vue');
const orderManage = () => import('../views/goods/order-manage.vue');
const orderDetail = () => import('../views/goods/order-detail.vue');
const plazaList = () => import('../views/plaza/plaza-list.vue');
const activityMember = () => import('../views/activitymanagement/activity-member.vue');

const videoManage = () => import('../views/shortvideo/video-manage.vue');
const qualificationList = () => import('../views/qualification/list.vue');
const qualificationDetail = () => import('../views/qualification/detail.vue');

export default [
  {
    path: "/",
    component: App,
    children: [
      {
        path: "/login",
        component: login,
        name: "loginPage",
      },
      {
        path: "",
        redirect: "/home",
      },
      {
        path: "/index",
        component: home,
      },
      {
        path: "/home",
        component: home,
      },
      {
        path: "/blank",
        component: blank,
      },
      {
        path: "/item-manager",
        component: itemManager,
      },
      {
        path: "/add-manager",
        component: addManager,
      },
      {
        path: "/edit-manager",
        component: editManager,
      },
      {
        path: "/edit-cme",
        component: editCme,
      },
      {
        path: "/edit-professional-exam",
        component: editProfessionalExam,
      },
      {
        path: "/subject-manager",
        component: subjectManager,
      },
      {
        path: "/report-download",
        component: reportDownload,
      },
      {
        path: "/teaching-popup",
        component: teachingPopup,
      },
      {
        path: "/editeach-popup",
        component: editeachPopup,
      },
      {
        path: "/edit-subject",
        component: editSubject,
      },
      {
        path: "/item-component",
        component: itemComponent,
      },
      {
        path: "/role",
        component: roleManager,
      },
      {
        path: "/circle-limit",
        component: circleLimit,
      },
      {
        path: "/create-component",
        component: createComponent,
      },
      {
        path: "/item-role",
        component: itemRole,
      },
      {
        path: "/report-list",
        component: reportLis,
      },
      {
        path: "/item-list",
        component: itemList,
      },
      {
        path: "/data-alignment",
        component: dataAlignment,
      },
      {
        path: "/name-list",
        component: nameList,
      },
      {
        path: "/export-download",
        component: exportDownload,
      },

      {
        path: "/report-list-old",
        component: reportLisOld,
      },
      {
        path: "/item-list-old",
        component: itemListOld,
      },
      {
        path: "/data-alignment-old",
        component: dataAlignmentOld,
      },
      {
        path: "/name-list-old",
        component: nameListOld,
      },
      {
        path: "/export-download-old",
        component: exportDownloadOld,
      },

      {
        path: "/item-shield",
        component: itemShield,
      },
      {
        path: "/entry-manager",
        component: entryManager,
      },
      {
        path: "/edit-entry",
        component: editEntry,
      },
      {
        path: "/msg-push",
        component: msgPush,
        // redirect: 'msgpush/msg-push',
      },
      {
        path: "/edit-notice",
        component: editNotice,
        // redirect: 'msgpush/msg-push',
      },
      {
        path: "/credit-manage",
        component: creditManage,
      },
      {
        path: "/review-access-manage",
        component: reviewAccessManage,
      },
      {
        path: "/credit-send-manage",
        component: creditSendManage,
      },
      {
        path: "/apply-detail",
        component: applyDetail,
      },
      {
        path: "/template-manager",
        component: templateManager,
      },
      {
        path: "/template-editor",
        component: templateEditor,
      },
      {
        path: "/template-open",
        component: templateOpen,
      },
      {
        path: "/edit-custom",
        component: editCustom,
      },
      {
        path: "/edu-role",
        component: eduRole,
      },
      {
        path: "/notice-editor",
        component: noticeEditor,
      },
      {
        path: "/yq-range",
        component: yqRange,
      },
      {
        path: "/activity-management",
        component: activityManagement,
      },
      {
        path: "/create-activity",
        component: createActivity,
      },
      {
        path: "/live-manage",
        component: liveManage,
      },
      {
        path: "/role-manage",
        component: roleManage,
      },
      {
        path: "/admin-manage",
        component: adminManage,
      },
      {
        path: "/create-range",
        component: createRange,
      },
      {
        path: "/range-manage",
        component: rangeManage,
      },
      {
        path: "/range-apply",
        component: rangeApply,
      },
      {
        path: "/create-live",
        component: createLive,
      },
      {
        path: "/edit-range",
        component: editRange,
      },
      {
        path: "/blacklist-manage",
        component: blackListManage,
      },
      {
        path: "/external-resource-manage",
        component: externalResourceManage,
      },
      {
        path: "/audit-custom-course",
        component: auditCustomCourse,
      },
      {
        path: "/advert-simple-manage",
        component: advertSimpleManage,
      },
      {
        path: "/edit-simple-advert",
        component: editSimpleAdvert,
      },
      {
        path: "/shop-list",
        component: shopList,
      },
      {
        path: "/create-shop",
        component: createShop,
      },
      {
        path: "/order-manage",
        component: orderManage,
      },
      {
        path: "/goods-manage",
        component: goodsManage,
      },
      {
        path: "/freight-config",
        component: freightConfig,
      },
      {
        path: "/create-good",
        component: createGood,
      },
      {
        path: "/create-good-new",
        component: createGoodNew,
      },
      {
        path: "/order-detail",
        component: orderDetail,
      },
      {
        path: "/plaza-list",
        component: plazaList,
      },
      {
        path: "/activity-member",
        component: activityMember,
      },
      {
        path: "video-manage",
        component: videoManage,
      },
      {
        path: "qualification-list",
        component: qualificationList,
      },
      {
        path: "qualification-detail",
        component: qualificationDetail,
      },
      // {
      //   path: '/followup',
      //   name: 'followUp',
      //   component: followUp,
      //   redirect: 'followup/plan-manage/planList',
      // },
      followRouters,
      patientsRouters,
    ],
  },
];
