import {
  getEnteringList,
  getEnteringInfo,
  getFormList,
} from '../../utils/followup/followapis'

export default {
  namespaced: true,
  state: {
    recordList: {}, //录入列表
    enteringInfo: {}, //单条信息查看
    constantsData: {}, //获取常量
    formList: {}, //获取量表列表
  },
  mutations: {
    GET_RECORD_LIST(state, payload) {
      state.recordList = payload
    },
    GET_ENTERING_INFO(state, payload) {
      state.enteringInfo = payload
    },
    GET_CONSTANS_DATA(state, payload) {
      state.constantsData = payload
    },
    GET_FORM_LIST(state, payload) {
      state.formList = payload
    },
  },
  actions: {
    async getRecordList(context, payload) {
      await getEnteringList({
        ...payload,
      }).then(({ data }) => {
        context.commit('GET_RECORD_LIST', data)
      })
    },
    async getEnteringInfo(context, payload) {
      await getEnteringInfo(
        payload.patientId,
        payload.fuPlanPatientTimesId
      ).then(({ data }) => {
        context.commit('GET_ENTERING_INFO', data)
      })
    },
    async getFormList(context, payload) {
      await getFormList(payload).then(({ data }) => {
        context.commit('GET_FORM_LIST', data)
      })
    },
  },
}
