import fetch from '../fetch'
import { getBaseUrl, getSaasDomain, getSaasApiDomain } from '@/utils/index'
let headers = {
  'Content-Type': 'application/json;charset=UTF-8',
  token: localStorage.getItem('storageToken'),
}

export const getVideoList = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/liteav/admin/list`),
    method: 'post',
    data: params,
    description: '获取短视频列表',
  })
}

export const getSwitch = () => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/liteav/admin/switch`),
    method: 'get',
    description: '获取视频审核开关',
  })
}

export const setSwitch = (btnVal) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/liteav/admin/switch/set?button=${btnVal}`),
    method: 'get',
    description: '设置视频审核开关',
  })
}

export const getVideoDetail = (id) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/liteav/admin/detail/${id}`),
    method: 'get',
    description: '获取短视频详情',
  })
}

export const manualCheck = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/liteav/admin/man/check`),
    method: 'post',
    data: params,
    description: '短视频人工审核',
  })
}
