export default ($this) => {
  return [



    {
      formType: 'div',
      name: '3.4 血脂异常',
      className: 'sec-title',
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'haveDyslipidemia',
      model: 'haveDyslipidemia',
      label: '随访期间是否新发现有血脂异常：',
      disabled: false,
      spanNum: 24,
      options: [
        { label: '否', value: '1', disabled: false },
        { label: '是', value: '2', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否', trigger: 'change' }],
      changeFun(e){
        if(e == 2) {
          $this.addComponents.forEach((item,index)=>{
            if(item.formName == 'stroke_009'){
              $this.addComponents[index].formObject = {
                ...$this.addComponents[index].formObject,
                dyslipidemia: []
              }
            }
          })
        }
      }
    },
    {
      formType: 'date-picker',
      className: 'obj-form-title2',
      prop: 'diagnoseTime',
      model: 'diagnoseTime',
      placeholder: '确诊时间',
      label: '确诊时间：',
      linkageRule: [{ name: 'haveDyslipidemia', value: ['2'] }],
      format: 'yyyy',
      valueFormat: 'yyyy',
      dateType: 'year',
      type: 'date',
      spanNum: 12,
      rules: [{ required: true, message: '请选择确诊时间', trigger: 'change' }]
    },
    {
      formType: 'checkbox',
      className: 'obj-form-title2',
      prop: 'dyslipidemia',
      model: 'dyslipidemia',
      label: '血脂异常类型：',
      linkageRule: [{name: 'haveDyslipidemia', value: ['2']}],
      disabled: false,
      changeFun: (val) => {
        // console.log(val)
      },
      spanNum: 24,
      options: [
        {label: '高胆固醇', value: '1', disabled: false},
        {label: '高甘油三酯', value: '2', disabled: false},
        {label: '高LDL-C', value: '3', disabled: false},
        {label: '低HDL-C', value: '4', disabled: false},
        {label: '不详', value: '5', disabled: false},
      ],
      rules: [{required: true, message: '请选择是否', trigger: 'change'}]
    },
    {
      formType: 'radio',
      className: 'obj-form-title2',
      prop: 'takeAntilipemicAgents',
      model: 'takeAntilipemicAgents',
      label: '是否服用调脂药：',
      linkageRule: [{name: 'haveDyslipidemia', value: ['2']}],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '否', value: '1', disabled: false },
        { label: '是', value: '2', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否', trigger: 'change' }],
      changeFun(e){
        if(e == 2) {
          $this.addComponents.forEach((item,index)=>{
            if(item.formName == 'stroke_009'){
              $this.addComponents[index].formObject = {
                ...$this.addComponents[index].formObject,
                antilipemicAgentsType: []
              }
            }
          })
        }
      }
    },
    {
      formType: 'checkbox',
      className: 'obj-form-title3',
      prop: 'antilipemicAgentsType',
      model: 'antilipemicAgentsType',
      label: '选择的调脂药：',
      linkageRule: [{name: 'takeAntilipemicAgents', value: ['2']}],
      disabled: false,
      changeFun: (val) => {
        // console.log(val)
      },
      spanNum: 24,
      options: [
        {label: '他汀类', value: '1', disabled: false},
        {label: '贝特类', value: '2', disabled: false},
        {label: '其他', value: '3', disabled: false},
      ],
      rules: [{required: true, message: '请选择是否', trigger: 'change'}]
    },

  ]
}
