import fetch from '../fetch';
import { getFollowUpApi, getBasicDataApi } from '@/utils/index'

import utils from './followupUtils';



/*计划管理API*/
const  planManageApi = [
  {
    url: '/followup/planPatient/',
    method: 'get',
    params: 'params',
    name: 'getResidentList',
    description: '获取居民列表',
  },
  {
    url: '/followup/plans/detail/',
    method: 'get',
    params: 'params',
    name: 'getPlanDetails',
    description: '获取计划详情',
  },
  {
    url: '/followup/planPatient/group',
    method: 'get',
    params: 'params',
    name: 'getGroupList',
    description: '获取分组列表',
  },
  {
    url: '/followup/planPatient/detail',
    method: 'get',
    params: 'params',
    name: 'getResidentDetail',
    description: '获取居民详情',
  },
  {
    url: '/followup/planPatient/change',
    method: 'put',
    params: 'params',
    name: 'changePlan',
    description: '变更计划',
  },
];

/*预约管理API*/
const reservationManageApi = [
  {
    url: '/followup/appointmentPatient/',
    method: 'get',
    params: 'params',
    name: 'getReservationList',
    description: '获取预约列表',
  },
  {
    url: '/followup/appointmentPatient/check/',
    method: 'get',
    params: 'params',
    name: 'getCheckReservation',
    description: '发送预约校验',
  },
  {
    url: '/followup/appointmentPatient/accept/',
    method: 'get',
    params: 'params',
    name: 'getReservationPatients',
    description: '查看预约人数',
  },
]


/*常量API*/
const basicDataApi = [
  {
    url: '/basic-data/constants/',
    method: 'get',
    params: 'params',
    name: 'getBasicData',
    description: '获取常量',
  },
]


const api = {};
const apis = [...planManageApi, ...reservationManageApi, ...basicDataApi];

apis.forEach(item => api[item.name] = (params = {}, extraConfig = {}) => {
  // const config = {
  //   url: getFollowUpApi(item.url),
  //   method: item.method,
  // };
let config = {};
  if(item.name == 'getBasicData'){
     config = {
      url: getBasicDataApi(item.url),
      method: item.method,
    };
  }else {
    config = {
      url: getFollowUpApi(item.url),
      method: item.method,
    };
  }

  if (extraConfig.urlSuffix) { // 需要做URL拼接的情况(比如*.do/2),,,可以根据自己的实际情况进行扩展
    config.url = `${config.url}${extraConfig.urlSuffix}`;
    //something else
  }
  const filterParams = utils.DC.getParams(params, item.args);
  if (item.params === 'data') {
    config.data = filterParams;
  } else {
    config.params = filterParams;
  }

  /*utils.MSG.$emit('axios:begin', item.url);*/
  return fetch({
    ...config,
    ...extraConfig,
  }).then(res => {
    return Promise.resolve(res);
  }).catch(err => {
    return Promise.resolve(err);
  });
});

export default api;
