import fetch from '../fetch';
import { getBaseUrl, getSaasDomain, getSaasApiDomain } from '@/utils/index'
let headers = {
  'Content-Type': 'application/json;charset=UTF-8',
  token: localStorage.getItem('storageToken'),
};

// 是否是外部用户
export const getUserTypeReq = (type) => {
  return fetch({
    headers,
    url: getBaseUrl(`api-ws/admin/auth/external`),
    method: 'get',
    description: '获取是否是外部用户',
  })
};

// 获取动态slideBar
export const getSlideData = (req) => {
  console.log("getSlideData() : token = " + localStorage.getItem('storageToken') + ", device_ip =" +
    localStorage.getItem("ipAddress") + ", browser_ver = " + localStorage.getItem("browser"));
  return fetch({
    headers,
    url: getBaseUrl(`contents/login/menu/list`),
    method: 'post',
    data: req,
    // token: localStorage.getItem('storageToken'),
    // system_type: 22,
    // device_ip: localStorage.getItem("ipAddress"),
    // browser_ver: localStorage.getItem("browser"),
  })
};

export const getSelectListReq = (type) => {
  return fetch({
    url: getBaseUrl(`cme/constants/list?code=${type}`),
    method: 'get',
    description: '获取学分等级 状态 学习形式',
  })
};

// export const getConstants = (params) => {
//     return fetch({
//       headers,
//       url: getBaseUrl(`basic-data/constants/`),
//       method: 'get',
//       params: params,
//       description: '获取常量',
//     })
// };


export const getCreditListReq = (params) => {
  return fetch({
    url: getBaseUrl(`cme/credit/list`),
    method: 'get',
    params: params,
    description: '获取积分管理列表',
  })
};



export const getRelatedCreditReq = (params) => {
  return fetch({
    url: getBaseUrl(`contents/certificate/select`),
    method: 'get',
    params: params,
    description: '获取关联学分证书列表',
  })
};

export const goUpReq = (data, id) => {
  return fetch({
    headers,
    url: getBaseUrl(`cme/credit/deploy/${id}`),
    method: 'post',
    data: data,
    description: '上架',
  })
}

export const goDownReq = (data, id) => {
  return fetch({
    headers,
    url: getBaseUrl(`cme/credit/revoke/${id}`),
    method: 'post',
    data: data,
    description: '下架',
  })
}

export const goAddNewReq = (data) => {
  return fetch({
    headers,
    // url: 'http://10.177.15.4:13801/cme/credit/create',
    url: getBaseUrl(`cme/credit/create`),
    method: 'post',
    data: data,
    description: '新增学分记录',
  })
}

// 审核权限管理页面
export const getAuthTableReq = (data) => {
  return fetch({
    headers,
    url: getBaseUrl(`cme/admin/auth/list`),
    method: 'post',
    data: data,
    description: '获取table列表',
  })
}

export const getAccessListReq = (params) => {
  return fetch({
    url: getBaseUrl(`cme/constants/list?code=approval_auth`),
    method: 'get',
    params: params,
    description: '获取权限下拉列表',
  })
};

 
export const getUserListReq = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`cme/admin/auth/userList`),
    method: 'get',
    params: params,
    description: '获取待选用户列表',
  })
};

export const handleSaveEditReq = (data) => {
  return fetch({
    headers,
    url: getBaseUrl(`cme/admin/auth/save`),
    method: 'post',
    data: data,
    description: '新增/编辑权限',
  })
}

export const handleDeleteReq = (data) => {
  return fetch({
    headers,
    url: getBaseUrl(`cme/admin/auth/remove`),
    method: 'post',
    data: data,
    description: '删除',
  })
}

// 学分发放管理页面
export const getSendListReq = (data) => {
  return fetch({
    headers,
    url: getBaseUrl(`cme/admin/credit/creditList`),
    method: 'post',
    data: data,
    description: '学分发放管理列表',
  })
}


// 学分申请明细页面
export const getDetailListReq = (data) => {
  return fetch({
    headers,
    url: getBaseUrl(`cme/admin/credit/creditDetails`),
    method: 'post',
    data: data,
    description: '学分申请明细列表',
  })
}

export const getCreditStatusReq = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`cme/admin/credit/creditStatusList`),
    method: 'get',
    params: params,
    description: '获取学分状态列表',
  })
};

export const handleImportReq = (data, cmeId) => {
  return fetch({
    headers,
    url: getBaseUrl(`cme/admin/credit/importExcel?cmeId=${cmeId}`),
    method: 'post',
    data: data,
    description: '导入',
  })
}

export const handleExportReq = (data) => {
  return fetch({
    headers,
    url: getBaseUrl(`cme/admin/credit/exportExcel`),
    method: 'post',
    data: data,
    description: '导出',
  })
}

export const circleMenu= (data) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/circle/judge/menu`),
    method: 'get',
    data: data,
    description: '判断用户是否有创建圈子菜单权限',
  })
}