import followApi from '../../../utils/followup/followapis'

export default {
  namespaced: true,
  state: {
    reservationList: { //居民列表
      pageNum: 1, //当前页码
      pageSize: 10, //每页数据大小
      total: null,  //总数
    },

  },
  mutations: {
    GET_RESERVATION_LIST(state, payload) {
      state.reservationList = payload
    },
  },
  actions: {
    getReservationList(context, payload) {
      const { pageSize, pageNum } = context.state.reservationList;
      followApi.getReservationList({
        pageSize,
        pageNum,
        ...payload
      }).then(({data}) => {
        context.commit('GET_RESERVATION_LIST', data);
      });
    }
  },
}
