import {getPlanList,
  getPlanDetail,
  getNodeTimeList,
  getNodeTimeContent,
  getResidentList,
  getGroupList,
  getResidentDetail,
  changePlan} from '../../utils/followup/followapis'

export default {
  namespaced: true,
  state: {
    residentList: { //居民列表
      pageNum: 1, //当前页码
      pageSize: 10, //每页数据大小
      total: null,  //总数
    },
    groupList: [],  //分组列表
    residentDetail: {}, //居民详情,
    planDetail: {}, // 计划详情页,
    nodeTimeList: [], //随访时间节点列表,
    nodeContent: {}, //时间节点详情
    planOption: [], //随访计划select
    timeNodeList: [],
    setTimeNodeList: [], //新建计划设置时间节点
    planList: {}, //随访计划列表
  },
  mutations: {
    GET_RESIDENT_LIST(state, payload) {
      state.residentList = payload
    },
    GET_GROUP_LIST(state, payload) {
      state.groupList = payload.labelDtoList
    },
    GET_RESIDENT_DETAIL(state, payload) {
      state.residentDetail = payload
      state.timeNodeList = payload.fPlanPatientDatilDtoList.timeNodeList
    },
    GET_PLAN_DETAIL(state, payload) {
      state.planDetail = payload
    },
    GET_NODE_TIME_LIST(state, payload) {
      state.nodeTimeList = payload
    },
    GET_NODE_CONTENT(state, payload) {
      state.nodeContent = payload
    },
    GET_PLAN_OPTION(state, payload) {
      state.planOption = payload.fPlanDtoList
    },
    SET_TIME_NODE_LIST(state, payload) {
      state.setTimeNodeList = payload;
    },
    GET_PLAN_LIST(state, payload) {
      state.planList = payload
    },
  },
  actions: {
    getResidentList(context, payload) {
      const { pageSize, pageNum } = context.state.residentList;
      getResidentList({
        pageSize,
        pageNum,
        ...payload
      }).then(({data}) => {
        context.commit('GET_RESIDENT_LIST', data);
      });
    },
    getGroupList(context, payload) {
      getGroupList({}).then(({data}) => {
        context.commit('GET_GROUP_LIST', data);
      });
    },
    getResidentDetail(context, payload) {
      getResidentDetail({
        ...payload
      }).then(({data}) => {
        context.commit('GET_RESIDENT_DETAIL', data);
      });
    },
    getPlanDetail(context, payload) {
      getPlanDetail(payload).then(({data}) => {
        context.commit('GET_PLAN_DETAIL', data);
      });
    },
    getNodeTimeList(context, payload) {
      getNodeTimeList(payload).then(({data}) => {
        context.commit('GET_NODE_TIME_LIST', data);
      });
    },
    getNodeTimeContent(context, payload) {
      getNodeTimeContent({}, {
        urlSuffix:payload
      }).then(({data}) => {
        context.commit('GET_NODE_CONTENT', data);
      });
    },
    getPlanOptions(context, payload) {
      getPlanList({
        pageNum: -1
      }).then(({data}) => {
        context.commit('GET_PLAN_OPTION', data);
      });
    },
   changePlan(context, payload) {
      changePlan({

      }).then(({data}) => {
       // context.commit('GET_PLAN_OPTION', data);
      });
    },
    async getPlanList(context, payload) {
      await followApi.getPlanList({
        ...payload
      }).then(({data}) => {
        context.commit('GET_PLAN_LIST', data);
      });
    },
  },
}
