const common = {
    state: {
        _token: '',
        idType: '',
        masterAdministratorFlag: false,
        itemComponents:{
          name:'',
          status:''
        },
        itemManager:{
          projectName: '',
          projectBegintime: '',
          projectEndtime: '',
          projectStatus: ''
        }
    },
    mutations: {
        CHANGE_TOKEN: (state, data) => {
            state._token = data
        },
        CHANGE_IDTYPE: (state, data) => {
            state.idType = data
        },
        CHANGE_MASTER: (state, data) => {
            state.masterAdministratorFlag = data
        },
        UPDATEITEM_COMPONENTS:(state, data) => {
          //console.log(data)
            state.itemComponents = {...data}
        },
        UPDATEITEM_MANAGER:(state, data) => {
          console.log(data)
            state.itemManager = {...data}
        },
    },
    actions: {
        changeToken({ commit }, tokenData) {
            commit('CHANGE_TOKEN', tokenData)
        },
        changeIdType({ commit }, idTypeData) {
            commit('CHANGE_IDTYPE', idTypeData)
        },
        changeMaster({ commit }, masterData) {
            commit('CHANGE_MASTER', masterData)
        },
        updateItemComponents({ commit }, masterData) {
            commit('UPDATEITEM_COMPONENTS', masterData)
        },
        updateItemManager({ commit }, masterData) {
            commit('UPDATEITEM_MANAGER', masterData)
        },
    }
}

export default common
