import fetch from '../fetch';
import { getBaseUrl } from '@/utils/index'
let headers = {
  'Content-Type': 'application/json;charset=UTF-8',
  token: localStorage.getItem('storageToken'),
};

export const saveStore = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`store/upsert`),
    method: 'post',
    data: params,
    description: '新建编辑店铺',
  })
};

export const queryStore = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`store/query`),
    method: 'post',
    data: params,
    description: '查询店铺信息',
  })
};

export const queryOrderDetail = (orderId) => {
  return fetch({
    headers,
    url: getBaseUrl(`store/orders/admin/query/${orderId}`),
    method: 'get',
    // params: params,
    description: '查询订单详情',
  })
};
///trade/order/admin/query/list
//store/orders/111/express

export const queryOrderList = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`store/orders/admin/query/list`),
    method: 'get',
    params: params,
    description: '查询订单列表',
  })
};

export const updateExpress = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`store/orders/admin/${params.id}/express`),
    method: 'post',
    data: params,
    description: '更新物流信息',
  })
};