const vueFilter = {
    liveDateFilter: (value) => {
        if (!value) return '';
        // var date = new Date(value);//时间戳为10位需*1000，时间戳为13位的话不需乘1000
        // var year = date.getFullYear(),
        // month = ("0" + (date.getMonth() + 1)).slice(-2),
        // sdate = ("0" + date.getDate()).slice(-2),
        // hour = ("0" + date.getHours()).slice(-2),
        // minute = ("0" + date.getMinutes()).slice(-2),
        // second = ("0" + date.getSeconds()).slice(-2);
        // // 拼接
        // var result = year + "-"+ month +"-"+ sdate +" "+ hour +":"+ minute +":" + second;
        // var result = `${month}-${sdate} ${hour}:${minute}`;
        // 返回
       // return result;
        return new Date(value).format("yyyy-MM-dd hh:mm:ss");
        // return new Date(value.replace(/\s/, 'T')).format("yyyy-MM-dd hh:mm:ss");
    },
    liveFilter: (value) => {
        if (value.liveStatus == 1) {
            return '未开始'
        } else if (value.liveStatus == 5) {
            return '直播中'
        } else if (value.liveStatus == 10 && value.lookBackStatus == 2) {
            return '已结束(不可回看)'
        } else if (value.liveStatus == 10 && value.lookBackStatus == 1) {
            return '已结束(可回看)'
        }
    },
    liveStatusFilter: (value) => {
        if (value == 1) return "隐藏"
        else return "发布"
    },
    liveTeacherType: (value) => {
        let doctorName = []
        if (value.length > 3) {
            for (let i = 0; i < 3; i++) {
                doctorName.push(value[i].doctorName)
            }
            return doctorName.join("、") + '...'
        } else {
            for (let i = 0; i < value.length; i++) {
                doctorName.push(value[i].doctorName)
            }
            return doctorName.join("、")
        }
    },
    controlType: (value) => {
        if (value == 1) {
            return '分页1'
        } else if (value == 2) {
            return '分页2'
        } else if (value == 3) {
            return '图片1'
        } else if (value == 4) {
            return '图片2'
        } else if (value == 6) {
            return '视频'
        }
    },
    tabControlType: (value) => {
        if (value == 3) {
            return '图片1'
        } else if (value == 4) {
            return '图片2'
        } else if (value == 6) {
            return '视频'
        }
    },
    refreshType: (value) => {
        if (value == 1) return "支持"
        else return "不支持"
    },
    moudleType: (value) => {
        if (value == 1) return "未激活"
        else return "激活"
    },
    dateFilter: (value) => {
        if (!value) return '';
        return new Date(value).format("yyyy-MM-dd hh:mm");
    },
    appColumnStatusFilter: (value) => {
        if (value == 1) return "未提交"
        else if (value == 4) return "已提交"
    },
    statusFilter: (value) => {
        if (value == 1) return "已创建"
        else if (value == 5) return "已发布"
        else return "已下架"
    },
    linkTypeFilter: (value) => { // 跳转类型
        if (value == 1) return '链接'
        else if (value == 4) return '模块'
        else return '无跳转'
    },
    teacherStatusFilter: (value) => {
        if (value == 1) return "已下架"
        else return "已发布"
    },
    moduleTypeFilter: (value, data) => {  // 模块类型
        for (let key in data) {
            if (value == key) {
                return data[key]
            }
        }
    },
    contentCreatedType: (value, data) => {
        for (let i = 0; i < data.length; i++) {
            if (value == data[i].id) {
                return data[i].name
            }
        }

    },
    contentModifiedType: (value, data) => {
        for (var i = 0; i < data.length; i++) {
            if (value == data[i].id) {
                return data[i].name
            }
        }
    },
    columnPositionType: (value, data) => {  // 位置
        for (let key in data) {
            if (value == key) {
                return data[key]
            }
        }
    },
    // 项目组件
    statusFileter: (value) => {
        if (value == 1) {
            return '草稿'
        } else if (value == 2) {
            return '未启用'
        } else if (value == 3) {
            return '已启用'
        } else {
            return '已禁用'
        }
    },
    //项目管理
    statusProject: (value) => {
        //console.log(value)
        if (value[0] == 1) {
            return '草稿'
        } else if (value[0] == 2) {
            return '未上架'
        } else if (value[0] == 3) {
            if (value[1] == 1) {
                return '待审核'
            } else {
                return '审核中'
            }
        } else if (value[0] == 4) {
            return '已上架'
        } else if (value[0] == 5) {
            return '已下架'
        } else if (value[0] == 6) {
            return '已拒绝'
        } else if (value[0] == 7) {
            return '待初审'
        } else if (value[0] == 8) {
            return '初审未通过'
        } else if (value[0] == 9) {
            return '待复审'
        } else if (value[0] == 10) {
            return '复审未通过'
        } else if (value[0] == 11) {
            return '复审通过'
        }
    },
    projeceRoleType: (value) => {
        if (value == "L1") {
            return '内部管理员'
        } else if (value == "L2") {
            return '项目负责人'
        } else if (value == "L3") {
            return '次级负责人'
        } else if (value == "L0") {
            return '普通用户'
        }
    },
    joinStatus: (value) => {
        if (value == "0") {
            return '未参与'
        } else if (value == "1") {
            return '参与中'
        } else {
            return '已完成'
        }
    },
    reportStatus: (value) => {
        if (value == 1) {
            return '进行中'
        } else if (value == 2) {
            return '已结束'
        } else if (value == 3) {
            return '已下架'
        }
    },
    partJoin: (value) => {
        if (value == 1) {
            return '未参与'
        } else {
            return '参与'
        }
    },
    partFinish: (value) => {
        if (value == 1) {
            return '未完成'
        } else {
            return '完成'
        }
    },
    projectStatus: (value) => {
        if (value == 1) {
            return '未参与'
        } else if (value == 2) {
            return '参与中'
        } else if (value == 3) {
            return '完成项目'
        }
    },
    recordValue: (value) => {
        if (value == 1) {
            return '无成绩'
        } else if (value == 2) {
            return '不通过'
        } else if (value == 3) {
            return '通过'
        }
    },
    exportStatus: (value) => {
        if (value == 0) {
            return '生成中';
        } else if (value == 1) {
            return '成功';
        } else {
            return '失败';
        }
    },
    getAvgTime: (value) => {
        let list = [0, 0];
        let avgTime = '';
        if (value != null && value != '') {
            list[0] = Math.floor(value / 60);
            list[1] = value % 60;
        }
        if (list[0] == 0 && list[1] == 0) {
            avgTime = list[1] + '秒';
        } else if (list[0] == 0 && list[1] != 0) {
            avgTime = list[1] + '秒';
        } else if (list[0] != 0 && list[1] == 0) {
            avgTime = list[0] + '分';
        } else if (list[0] != 0 && list[1] != 0) {
            avgTime = list[0] + '分' + list[1] + '秒';
        }
        return avgTime;
    },
    learnTimeValue: (value) => {
        if (value === null || value === '') {
            return '-';
        }
        if (value === 0) {
            return '0秒';
        }
        let s = parseInt(value), m = 0, h = 0;//秒，分，小时
        if (s == NaN) {//错误error
            return '';
        }
        if (s > 60) {
            m = parseInt(s / 60);
            s = parseInt(s % 60);
            if (m > 60) {
                h = parseInt(m / 60);
                m = parseInt(m % 60);
            }
        }
        let result = "";
        if (s > 0) {
            result = "" + parseInt(s) + "秒";
        }
        if (m > 0) {
            result = "" + parseInt(m) + "分" + result;
        }
        if (h > 0) {
            result = "" + parseInt(h) + "小时" + result;
        }
        return result;
    },
    getTotalTime: (value) => {
        let time = value + '分钟';
        return time;
    },
    shieldStatus: (value) => {
        if (value == 1) {
            return '未屏蔽';
        } else if (value == 2) {
            return '已屏蔽';
        }
    },
    shieldButton: (value) => {
        if (value == 1) {
            return '屏蔽';
        } else if (value == 2) {
            return '取消屏蔽';
        }
    },
    areaText: (value) => {
        let text = '-';
        if (value.regions.length == 0) {
            text = '-'
        } else if (value.regions.length == 1) {
            text = value.regions[0];
        } else if (value.regions.length > 1) {
            let len = value.regions.length;
            text = value.regions[0] + '(' + len + ')';
        }
        return text;
    },
    areaList: (value) => {
        let list = '';
        for (let i = 0; i < value.length; i++) {
            list += value[i] + '、';
        }
        list = list.substring(0, list.length - 1);
        return list
    },
    entryStatusType: (value) => {
        if (value == 1) {
            return '草稿';
        } else if (value == 2) {
            return '未上架';
        } else if (value == 3) {
            return '已上架';
        } else if (value == 4) {
            return '已下架';
        }
    },
    examRate: (value) => {
        let num = (value * 100).toFixed(1);
        let rate = num + '%';
        return rate;
    },
    sexValue: (value) => {
        if (value == 1) {
            return '男';
        } else if (value == 2) {
            return '女';
        } else if (value == 0) {
            return '-';
        }
    },
    joinFlagValue: (value) => {
        if (value === 1) {
            return '已参与';
        } else if (value === 2 || value === 0) {
            return '未参与';
        } else {
            return '-';
        }
    },
    finishFlagValue: (value) => {
        if (value === 1) {
            return '已完成';
        } else if (value === 2 || value === 0) {
            return '未完成';
        } else {
            return '-';
        }
    },
    departmentNameValue: (value) => {
        if (value === '') {
            return '-';
        }
        return value;
    },
    nullOfValue: (value) => {
        if (value === null || value === '') {
            return '-';
        }
        return value;
    },
    certGradeValue: (value) => {
        if (value == 1) {
            return '优秀';
        } else if (value == 2) {
            return '良好';
        } else if (value == 3) {
            return '及格';
        } else if (value == 4) {
            return '不及格';
        } else {
            return '-';
        }
    },
    finishFlagType: (value) => {
        if (value[0] === null || value[0] === '') {
            return '-';
        }
        if (value[1] === null) {
            if (value[0] == 0) {
                return '未参与';
            } else if (value[0] == 1) {
                return '未完成';
            } else if (value[0] == 2) {
                return '已完成';
            }
        } else {
            if (value[0] == 0) {
                return '未参与';
            } else if (value[0] == 1) {
                return '已参与';
            }
        }
    },
    toThousands: (value) => {
        return (value || 0).toString().replace(/(\d)(?=(?:\d{3})+$)/g, '$1,');
    },

    // 1.草稿 2.未上架 3.审核中/待审核（非自己编辑的待审核项目显示待审核，自己编辑的待审核项目显示审核中）
    //  4.已上架 5.已下架 6.已拒绝/未上架
    templateStatus: (value, owner) => {
        if (value == 1) {
            return '草稿';  // 一般不会显示
        } else if (value == 2) {
            return '未上架';
        } else if (value == 300) {
            return '审核中';
        } else if (value == 3) {
            return '待审核';
        } else if (value == 4) {
            return '已上架';
        } else if (value == 5) {
            return '已下架';
        } else if (value == 6) {
            return '已拒绝';
        }
    },
    roleStatus: (value) => {
        if (value == 0) {
            return '未开通';
        } else if (value == 1) {
            return '已开通';
        }
    },
    replaceStr: (value) => {
        if (value === '' || value === null) {
            return '一'
        } else {
            return value
        }
    },
    // 将字符串截短至指定长度，并用在最后追加特定字符串（例如：...）
    shortName: (value, length = 24, append = '...') => {
        if (value && value.length > length) {
            return value.substring(0, length) + append
        } else {
            return value
        }
    },
    // 云鹊小圈 内容发布权限
    dynamicFlagStatus: (value) => {
      if (value == 1) {
        return '所有人可发布'
      }else if (value == 2) {
        return '管理员可发布'
      }else {
        return '-'
      }
    },
    // 圈子状态 0:暂存 10:待发布（已保存） 20:已发布（已提交待审核、审核被拒绝） 30:已上架（审核通过）40：下架 50：解散
    rangeStatus: (value) => {
        if (value == 0) {
            return '暂存'
        }else if (value == 10) {
            return '下线'
        }else if (value == 20) {
            return ''
        }else if (value == 30) {
          return '上线'
        } else if (value == 40) {
          return '下线'
        }else if (value == 50) {
          return '已解散'
        }else {
            return '-'
        }
    },
    liveStatusFilter: (value) => {
        if (value == 1) {
            return '预告'
        }else if (value == 2) {
            return '直播中'
        }else if (value == 3) {
            return '已结束'
        }else {
            return '-'
        }
    },
}
export default vueFilter
