export default ($this) => {
  return [


    {
      formType: 'div',
      name: '3.2 心脏病',
      className: 'sec-title',
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'happenedAgain',
      model: 'happenedAgain',
      label: '随访期间是否新发心脏病：',
      disabled: false,
      spanNum: 24,
      options: [
        { label: '无', value: '无', disabled: false },
        { label: '有', value: '有', disabled: false },
      ],
      rules: [{ required: true, message: '请选择随访期间是否新发心脏病', trigger: ['submit','change'] }],
      changeFun(e){
        if(e == '有') {
          $this.addComponents.forEach((item,index)=>{
            if(item.formName == 'stroke_007'){
              $this.addComponents[index].formObject = {
                ...$this.addComponents[index].formObject,
                type: []
              }
            }
          })
        }
      }
    },
    {
      formType: 'date-picker',
      className: 'obj-form-title2',
      prop: 'firstDiagnoseTime',
      model: 'firstDiagnoseTime',
      placeholder: '请选择',
      label: '首次确诊时间：',
      linkageRule: [{ name: 'happenedAgain', value: ['有'] }],
      format: 'yyyy',
      valueFormat: 'yyyy',
      dateType: 'year',
      type: 'date',
      rules: [{ required: true, message: '请选择首次确诊时间', trigger: ['submit','change'] }],
      spanNum: 6,
    },
    {
      formType: 'checkbox',
      className: 'obj-form-title2',
      prop: 'type',
      model: 'type',
      label: '心脏病类型：',
      linkageRule: [{ name: 'happenedAgain', value: ['有'] }],
      disabled: false,
      changeFun: (val)=>{
        // console.log(val)
      },
      spanNum: 24,
      options: [
        { label: '冠心病', value: '冠心病', disabled: false },
        { label: '房颤', value: '房颤', disabled: false },
        { label: '瓣膜性心脏病', value: '瓣膜性心脏病', disabled: false },
        { label: '具体不详', value: '具体不详', disabled: false },
        { label: '其他', value: '其他', disabled: false },
      ],
      rules: [{ required: true, message: '请选择心脏病类型', trigger: ['submit'] }]
    },
    {
      formType: 'input',
      className: 'obj-form-title4',
      linkageRule: [{name: 'type',value: ['其他']}],
      prop: 'remark',
      model: 'remark',
      disabled: false,
      placeholder: '请输入其他心脏病类型',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      rules: [{ required: true, message: '请输入其他心脏病类型', trigger: ['submit','change'] }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title3',
      prop: 'coronaryDiseaseType',
      model: 'coronaryDiseaseType',
      label: '冠心病类型：',
      linkageRule: [{ name: 'type', value: ['冠心病'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '心绞痛', value: '心绞痛', disabled: false },
        { label: '心肌梗塞', value: '心肌梗塞', disabled: false },
        { label: '无症状冠脉狭窄', value: '无症状冠脉狭窄', disabled: false },
      ],
      rules: [{ required: true, message: '请选择冠心病类型', trigger: ['submit','change'] }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title3',
      prop: 'atrialFibrillationType',
      model: 'atrialFibrillationType',
      label: '房颤类型：',
      linkageRule: [{ name: 'type', value: ['房颤'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '阵发型', value: '阵发型', disabled: false },
        { label: '持续性', value: '持续性', disabled: false },
        { label: '未知', value: '未知', disabled: false },
      ],
      rules: [{ required: true, message: '请选择房颤类型', trigger: ['submit','change'] }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title2',
      prop: 'hospitalLevel',
      model: 'hospitalLevel',
      label: '就诊机构级别：',
      linkageRule: [{ name: 'happenedAgain', value: ['有'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '省级医院', value: '省级医院', disabled: false },
        { label: '地级市医院', value: '地级市医院', disabled: false },
        { label: '县级医院', value: '县级医院', disabled: false },
        { label: '社区或乡镇卫生机构', value: '社区或乡镇卫生机构', disabled: false },
      ],
      rules: [{ required: true, message: '请选择就诊机构级别', trigger: ['submit','change'] }]
    },


    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'atrialFibrillation',
      model: 'atrialFibrillation',
      label: '是否有房颤（包括既往及本次随访期间新发现的房颤患者）：',
      disabled: false,
      spanNum: 24,
      options: [
        { label: '无', value: '无', disabled: false },
        { label: '有', value: '有', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否有房颤', trigger: ['submit','change'] }],

    },
    {
      formType: 'radio',
      className: 'obj-form-title2',
      prop: 'takeAntithrombotics',
      model: 'takeAntithrombotics',
      label: '是否服用抗栓药物：',
      linkageRule: [{ name: 'atrialFibrillation', value: ['有'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '否', value: '否', disabled: false },
        { label: '是', value: '是', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否服用抗栓药物', trigger: ['submit','change'] }],
      changeFun(e){
        if(e == '是') {
          $this.addComponents.forEach((item,index)=>{
            if(item.formName == 'stroke_007'){
              $this.addComponents[index].formObject = {
                ...$this.addComponents[index].formObject,
                drugVariety: []
              }
            }
          })
        }
      }

    },
    {
      formType: 'checkbox',
      className: 'obj-form-title3',
      prop: 'drugVariety',
      model: 'drugVariety',
      label: '用药品种：',
      linkageRule: [{ name: 'takeAntithrombotics', value: ['是'] }],
      disabled: false,
      changeFun: (val)=>{
        // console.log(val)
      },
      spanNum: 24,
      options: [
        { label: '华法林', value: '华法林', disabled: false },
        { label: '新型抗凝剂', value: '新型抗凝剂', disabled: false },
        { label: '阿司匹林', value: '阿司匹林', disabled: false },
        { label: '氯吡格雷', value: '氯吡格雷', disabled: false },
        { label: '其他', value: '其他', disabled: false },
      ],
      rules: [{ required: true, message: '请选择用药品种', trigger: ['submit'] }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title3',
      prop: 'medicationSituation',
      model: 'medicationSituation',
      label: '用药情况：',
      linkageRule: [{ name: 'takeAntithrombotics', value: ['是'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '规律', value: '规律', disabled: false },
        { label: '不规律', value: '不规律', disabled: false },
      ],
      rules: [{ required: true, message: '请选择用药情况', trigger: ['submit','change'] }]
    },




  ]
}
