/**
 * Created by Anndy Yang on 18/09/18.
 */
import { envConfig } from '@/utils/env-config'

export function setEventByModuleCode(itemData){
  let modeCode = itemData.appModuleInfo.code || '';
  let paramList = itemData.appModuleInfo.paramList ? itemData.appModuleInfo.paramList : ''
  if( modeCode === 'M001' || modeCode === 'M002' || modeCode === 'M003') {
      paramList = ''
  }else if( modeCode === 'M100' || modeCode === 'M300' ) {

    let urlPara = getUrlParmByCode(paramList);
    paramList[0] && (paramList[0].value += urlPara);

  }else if( modeCode === 'M400') {

      let path = paramList[0]['key'];
      let v = paramList[0]['value'];
      let query = setRouterParm(paramList);
  }
  if(typeof paramList === 'string' && !paramList){
      paramList = []
  }

  return paramList;
}

function getUrlParmByCode(paramList) {
    if ( paramList.length <= 1) {
        return ''
    }
    let dataStr = ''
    let list = [];
    for( let i = 1; i < paramList.length; i ++) {
        list.push(paramList[i].key + '=' + paramList[i].value)
    }
    dataStr = list.join('&')
    if (dataStr !== '') {
        return '?' + dataStr
    }
    return ''
}

// 计算高度
export function resizeHeight(cMinusHeight = 152, iMinuxHeight = 210, refHeightId = 'sidebarWrapperId',
  containerHeightId = 'appContainerId', innerHeightId = 'elTableId'){
  if (!p_getElm(refHeightId) || !p_getElm(containerHeightId) || !p_getElm(innerHeightId)) {
    // window.onresize = null
    logger.warn('No certain dom id!!!');
  }
  let containerHeight = p_getElm(refHeightId).getBoundingClientRect().height - 50
  p_getElm(containerHeightId).style.height = containerHeight - cMinusHeight + 'px'
  p_getElm(innerHeightId).style.height = containerHeight - iMinuxHeight + 'px'
  if(p_getElm('elTableIdInner')){
    p_getElm('elTableIdInner').style.height = containerHeight - iMinuxHeight + 'px'
  }
  window.onresize = function() {
    containerHeight = p_getElm(refHeightId).getBoundingClientRect().height - 50
    p_getElm(containerHeightId).style.height = containerHeight - cMinusHeight + 'px'
    p_getElm(innerHeightId).style.height = containerHeight - iMinuxHeight + 'px'
    if (p_getElm('elTableIdInner')) {
      p_getElm('elTableIdInner').style.height = containerHeight - iMinuxHeight + 'px'
    }
  }
}

function p_getElm(elmId) {
  return document.getElementById(elmId)
}




export function deepCopy(obj) {
  var result = Array.isArray(obj) ? [] : {};
  for (var key in obj) {
    if (obj.hasOwnProperty(key)) {
      if (typeof obj[key] === 'object') {
        result[key] = deepCopy(obj[key]);   //递归复制
      } else {
        result[key] = obj[key];
      }
    }
  }
  return result;
}

/**
 *
 * @param {Array}     originData  初始数据
 * @param {Boolean}   isUp        true: 升序  false: 降序
 * @param {String}    sortField   排序字段，如果没有，则直接排序
 * @param {Function}  converFun   字段对应的数值转换函数
 */
export function arraySort(originData, isUp = true, sortedField, converFun) {
  // debugger
  let sortedData = originData.slice(), swap, sourceA, sourceB;
  for(let i = 0; i < sortedData.length - 1; i ++) {
    for(let j = 0; j < sortedData.length - i -1; j++) {
      sourceA = sortedData[j]
      sourceB = sortedData[j + 1]
      if(sortedField && !converFun) {
        sourceA = sourceA[sortedField]
        sourceB = sourceB[sortedField]
      } else if(sortedField && converFun && typeof converFun === 'function'){
        if(!sourceA[sortedField] || !sourceB[sortedField]) {
          sourceA = 0
          sourceB = 0
        } else {
          sourceA = converFun(sourceA[sortedField])
          sourceB = converFun(sourceB[sortedField])
        }
      }
      // if(!sourceA || !sourceB) {
      //   sourceA = 0
      //   sourceB = 0
      // }
      if(isUp) {
        if((sourceA - 0) > (sourceB - 0)) {
          swap = sortedData[j]
          sortedData[j] = sortedData[j + 1]
          sortedData[j + 1] = swap
        }
      } else {
        if((sourceA - 0) < (sourceB - 0)) {
          swap = sortedData[j]
          sortedData[j] = sortedData[j + 1]
          sortedData[j + 1] = swap
        }
      }
    }
  }
  return sortedData
}


export function sortParmData(originData, orderCol, index) {
  return originData.sort((a, b) => {
    return (a[orderCol] - b[orderCol] ) * -1
  })
}

// 获取SC服务器域名地址
export function getBaseUrl(url) {
  return getConfigByEnvType('baseUrl') + url
}

// 获取七牛token
export function getQiniuToken1() {
  return getConfigByEnvType('qiniuFileUrl')
}

// 登录URL
export function getLoginUrl(param) {
  return getConfigByEnvType('loginUrl') + param
}
export function getInnerLoginUrl() {
  return getConfigByEnvType('innerLoginUrl')
}

// 云鹊医首页
export function getYunQueYiUrl() {
  return getConfigByEnvType('yuequeyiIndexUrl')
}

// 七牛上传视频和图片
export function uploadVideo() {
  return getConfigByEnvType('qiniuResourceUrl')
}
export function uploadImg() {
  return getConfigByEnvType('qiniuImgUrl')
}

// 获取履约微服务服务器域名地址
export function getFollowUpSC(url) {
  return getConfigByEnvType('followUpSC') + url
}

// 获取常量接口域名地址
export function getBasicDataApi(url) {
  return getConfigByEnvType('basicDataUrl') + url
}

// 获取saas端域名地址
export function getSaasDomain(url) {
  return getConfigByEnvType('saasDomainUrl') + url
}
// 获取saasApi端域名地址
export function getWorkApi(url) {
  return getConfigByEnvType('workApiUrl') + url
}

// 获取saas端api域名地址
export function getSaasApiDomain(url) {
  return getConfigByEnvType('apiUrl') + url
}

// 获取工作站的域名地址
export function getWorkDomain(url) {
  return getConfigByEnvType('workApiSrc') + url
}

// 根据不同环境，生成URL
function getConfigByEnvType(urlType) {
  return envConfig[process.env.BUILD_ENV][urlType]
}


// 获取report服务器域名地址
export function getReportUrl(url) {
  return getConfigByEnvType('reportUrl') + url
}

// 获取Excel地址
export function getExeclUrl(url) {
  return getConfigByEnvType('excelUrl') + url
}

// 获取教培项目文件地址
export function getItemFileUrl(url) {
  return getConfigByEnvType('itemFileUrl') + url
}

// 获取老的cms接口域名地址
export function getCmsUrl(url) {
  return getConfigByEnvType('cmsUrl') + url
}