import { checkMobile } from '@/utils/followup/followupUtils/checkField';

export default ($this) => {
  return [

    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'hasSymptom',
      model: 'hasSymptom',
      label: '是否有症状：',
      disabled: false,
      spanNum: 24,
      options: [
        { label: '无', value: '无', disabled: false },
        { label: '有', value: '有', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否有症状', trigger: ['submit','change'] }],
      changeFun: (e) => {
        if(e == '有') {
          $this.addComponents.forEach((item,index)=>{
            if(item.name == 'hypeDataSourceSymptom'){
              $this.addComponents[index].formObject = {
                ...$this.addComponents[index].formObject,
                symptom: []
              }
            }
          })
        }
      }

    },
    {
      formType: 'checkbox',
      className: 'float-none obj-form-title2',
      linkageRule: [{name: 'hasSymptom', value: ['有']}],
      prop: 'symptom',
      model: 'symptom',
      label: '症状类型：',
      disabled: false,
      changeFun: (val) => {
      },
      spanNum: 24,
      options: [
        // {label: '无症状', value: '无症状', disabled: false},
        {label: '头痛头晕', value: '头痛头晕', disabled: false},
        {label: '恶心呕吐', value: '恶心呕吐', disabled: false},
        {label: '眼花耳鸣', value: '眼花耳鸣', disabled: false},
        {label: '呼吸困难', value: '呼吸困难', disabled: false},
        {label: '心悸胸闷', value: '心悸胸闷', disabled: false},
        {label: '鼻衄出血不止', value: '鼻衄出血不止', disabled: false},
        {label: '四肢发麻', value: '四肢发麻', disabled: false},
        {label: '下肢水肿', value: '下肢水肿', disabled: false},
        {label: '其他', value: '其他', disabled: false},
      ],
      rules: [{required: true, message: '选择的症状', trigger: ['submit']}]
    },
    {
      formType: 'input',
      className: 'float-none obj-form-title3',
      linkageRule: [{name: 'symptom',value: ['其他']}],
      prop: 'remark',
      model: 'remark',
      disabled: false,
      placeholder: '请输入其他症状',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      rules: [{ required: true, message: '请输入其他症状', trigger: ['submit','change'] }]
    },

  ]
}

