import App from '../App'

const home = r => require.ensure([], () => r(require('../views/home')), 'home')
const blank = r => require.ensure([], () => r(require('../views/blank')), 'blank')
const itemManager = r => require.ensure([], () => r(require('../views/education/item-manager.vue')), 'item-manager')
const itemComponent = r => require.ensure([], () => r(require('../views/education/item-component.vue')), 'item-component')
const createComponent = r => require.ensure([], () => r(require('../views/education/create-component.vue')),'create-component')
const roleManager = r => require.ensure([], () => r(require('../views/system/role.vue')),'role')
const addManager = r => require.ensure([], () => r(require('../views/education/add-manager.vue')), 'add-manager')
const itemRole = r => require.ensure([], () => r(require('../views/system/item-role.vue')), 'item-role')
const itemList = r => require.ensure([], () => r(require('../views/learning/item-list.vue')), 'item-list')

export default [{
    path: '/',
    component: App,
    children: [
        {
            path: '',
            redirect: '/home'
        },{
            path: '/index',
            component: home
        },{
            path: '/home',
            component: home
        },{
            path: '/blank',
            component: blank
        },{
            path: '/item-manager',
            component: itemManager
        },{
            path: '/add-manager',
            component: addManager
        },{
            path: '/item-component',
            component: itemComponent
        },{
            path: '/role',
            component: roleManager
        },{
            path: '/create-component',
            component: createComponent
        },{
            path: '/item-role',
            component: itemRole
        },{
            path: '/item-list',
            component: itemList
        },
    ]
}]