import fetch from '../fetch';
import { getBaseUrl, getSaasDomain } from '@/utils/index'


const headers = {
  sysCode: 9
} /**/
/*工作台*/
export const getDiseasesList = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/patients/diseases/-1`),
    method: 'get',
    params: params,
    description: '获取所有疾病',
  })
};

/*资料不全居民*/
export const getNotCompleteList = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/patients/uncomplate/${params.pageNo}/${params.pageSize}`),
    method: 'get',
    params: params,
    description: '获取资料不全居民列表',
  })
};
export const sendCompleteMessage = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/patients/remind`),
    method: 'post',
    data: params,
    description: '提醒居民完善信息',
  })
};
export const getNotCompleteCount = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/patients/uncomplate/counts`),
    method: 'get',
    data: params,
    description: '获取未完善居民人数',
  })
};
