export default [
  {
    formType: 'div',
    name: '3.1 脑血管病',
    className: 'sec-title',
  },
  {
    formType: 'radio',
    prop: 'c1',
    model: 'c1',
    label: '随访期间有无新发脑血管病事件',
    disabled: false,
    spanNum: 24,
    options: [
      { label: '无', value: '1', disabled: false },
      { label: '有', value: '2', disabled: false },
    ],
    rules: [{ required: true, message: '请选择是否', trigger: 'blur' }]
  },
  {
    formType: 'input',
    linkageRule: [{name: 'c1',value: ['2']}],
    prop: 'c2',
    model: 'c2',
    label: '发病次数',
    disabled: false,
    placeholder: '请输入发病次数',
    spanNum: 24,
    type: 'number',
    labmsg: '次',
    slots: [{ name: '次', type: 'append' }]
  },
  {
    formType: 'date-picker',
    prop: 'c3',
    model: 'c3',
    placeholder: '请选择',
    label: '随访期间第一次发病时间',
    linkageRule: [{ name: 'c1', value: ['2'] }],
    format: 'yyyy-MM-dd',
    type: 'date',
    rules: [{ required: true, message: '请选择随访期间第一次发病时间', trigger: 'blur' }],
    spanNum: 24,
  },
  {
    formType: 'radio',
    prop: 'c4',
    model: 'c4',
    label: '就诊机构级别',
    linkageRule: [{ name: 'c1', value: ['2'] }],
    disabled: false,
    spanNum: 24,
    options: [
      { label: '省级医院', value: '1', disabled: false },
      { label: '地市级医院', value: '2', disabled: false },
      { label: '县级医院', value: '3', disabled: false },
      { label: '社区或乡镇卫生机构', value: '4', disabled: false },
    ],
    rules: [{ required: true, message: '请选择是否', trigger: 'blur' }]
  },
  {
    formType: 'radio',
    prop: 'c5',
    model: 'c5',
    label: '主要诊断',
    linkageRule: [{ name: 'c1', value: ['2'] }],
    disabled: false,
    spanNum: 24,
    options: [
      { label: '脑梗死', value: '1', disabled: false },
      { label: '脑出血', value: '2', disabled: false },
      { label: '蛛网膜下腔出血', value: '3', disabled: false },
      { label: '短暂性脑缺血发作（TIA）', value: '4', disabled: false },
    ],
    rules: [{ required: true, message: '请选择是否', trigger: 'blur' }]
  },
  {
    formType: 'radio',
    prop: 'c6',
    model: 'c6',
    label: '住院期间是否接受康复治疗',
    linkageRule: [{ name: 'c1', value: ['2'] }],
    disabled: false,
    spanNum: 24,
    options: [
      { label: '否', value: '1', disabled: false },
      { label: '是', value: '2', disabled: false },
    ],
    rules: [{ required: true, message: '请选择是否', trigger: 'blur' }]
  },
  {
    formType: 'radio',
    prop: 'c7',
    model: 'c7',
    label: '出院后是否接受康复治疗',
    linkageRule: [{ name: 'c1', value: ['2'] }],
    disabled: false,
    spanNum: 24,
    options: [
      { label: '否', value: '1', disabled: false },
      { label: '是', value: '2', disabled: false },
    ],
    rules: [{ required: true, message: '请选择是否', trigger: 'blur' }]
  },


  {
    formType: 'div',
    name: '3.2 MRS评分',
    className: 'sec-title',
  },
  {
    formType: 'date-picker',
    prop: 'c8',
    model: 'c8',
    placeholder: '请选择',
    label: '评估时间',
    format: 'yyyy-MM-dd',
    type: 'date',
    rules: [{ required: true, message: '请选择评估时间', trigger: 'blur' }],
    spanNum: 24,
  },
  {
    formType: 'radio',
    prop: 'c9',
    model: 'c9',
    label: '评分值',
    disabled: false,
    spanNum: 24,
    options: [
      { label: '0（完全无症状）', value: '1', disabled: false },
      { label: '1（尽管有症状，但无明显功能障碍，能完成所有日常工作和生活）', value: '2', disabled: false },
      { label: '2（轻度残疾，不能完成病前所有活动，但不需帮助能照顾自己的日常生活）', value: '3', disabled: false },
      { label: '3（中度残疾，需部分帮助，但能独立行走）', value: '4', disabled: false },
      { label: '4（重度残疾，不能独立行走，无他人帮助不能满足自身日常生活需求）', value: '5', disabled: false },
      { label: '5（严重残疾，持续卧床、二便失禁，需持续护理和关注，日常生活完全依赖他人）', value: '6', disabled: false },
    ],
    rules: [{ required: true, message: '请选择评分值', trigger: 'blur' }]
  },


  {
    formType: 'div',
    name: '3.3 心脏病',
    className: 'sec-title',
  },
  {
    formType: 'radio',
    prop: 'c10',
    model: 'c10',
    label: '随访期间是否新发心脏病',
    disabled: false,
    spanNum: 24,
    options: [
      { label: '无', value: '1', disabled: false },
      { label: '有', value: '2', disabled: false },
    ],
    rules: [{ required: true, message: '请选择是否', trigger: 'blur' }]
  },
  {
    formType: 'date-picker',
    prop: 'c15',
    model: 'c15',
    placeholder: '请选择',
    label: '首次确诊时间',
    linkageRule: [{ name: 'c10', value: ['2'] }],
    format: 'yyyy-MM-dd',
    type: 'date',
    rules: [{ required: true, message: '首次确诊时间', trigger: 'blur' }],
    spanNum: 24,
  },
  {
    formType: 'radio',
    prop: 'c16',
    model: 'c16',
    label: '心脏病类型',
    linkageRule: [{ name: 'c10', value: ['2'] }],
    disabled: false,
    spanNum: 24,
    options: [
      { label: '冠心病', value: '1', disabled: false },
      { label: '房颤', value: '2', disabled: false },
      { label: '瓣膜性心脏病', value: '3', disabled: false },
      { label: '具体不详', value: '4', disabled: false },
      { label: '其他', value: '5', disabled: false },
    ],
    rules: [{ required: true, message: '请选择评分值', trigger: 'blur' }]
  },
  {
    formType: 'radio',
    prop: 'c18',
    model: 'c18',
    label: '冠心病类型',
    linkageRule: [{ name: 'c16', value: ['1'] }],
    disabled: false,
    spanNum: 24,
    options: [
      { label: '心绞痛', value: '1', disabled: false },
      { label: '心肌梗塞', value: '2', disabled: false },
      { label: '无症状冠脉狭窄', value: '3', disabled: false },
    ],
    rules: [{ required: true, message: '请选择冠心病类型', trigger: 'blur' }]
  },
  {
    formType: 'radio',
    prop: 'c19',
    model: 'c19',
    label: '房颤类型',
    linkageRule: [{ name: 'c16', value: ['2'] }],
    disabled: false,
    spanNum: 24,
    options: [
      { label: '阵发型', value: '1', disabled: false },
      { label: '持续性', value: '2', disabled: false },
      { label: '未知', value: '3', disabled: false },
    ],
    rules: [{ required: true, message: '请选择房颤类型', trigger: 'blur' }]
  },
  {
    formType: 'radio',
    prop: 'c17',
    model: 'c17',
    label: '就诊机构级别',
    linkageRule: [{ name: 'c10', value: ['2'] }],
    disabled: false,
    spanNum: 24,
    options: [
      { label: '省级医院', value: '1', disabled: false },
      { label: '地级市医院', value: '2', disabled: false },
      { label: '县级医院', value: '3', disabled: false },
      { label: '社区或乡镇卫生机构', value: '4', disabled: false },
    ],
    rules: [{ required: true, message: '请选择评分值', trigger: 'blur' }]
  },


  {
    formType: 'radio',
    prop: 'c11',
    model: 'c11',
    label: '是否有房颤（包括既往及本次随访期间新发现的房颤患者）',
    disabled: false,
    spanNum: 24,
    options: [
      { label: '无', value: '1', disabled: false },
      { label: '有', value: '2', disabled: false },
    ],
    rules: [{ required: true, message: '请选择是否', trigger: 'blur' }]
  },
  {
    formType: 'radio',
    prop: 'c20',
    model: 'c20',
    label: '是否服用抗栓药物',
    linkageRule: [{ name: 'c11', value: ['2'] }],
    disabled: false,
    spanNum: 24,
    options: [
      { label: '否', value: '1', disabled: false },
      { label: '是', value: '2', disabled: false },
    ],
    rules: [{ required: true, message: '请选择是否', trigger: 'blur' }]
  },
  {
    formType: 'radio',
    prop: 'c21',
    model: 'c21',
    label: '心脏病类型',
    linkageRule: [{ name: 'c20', value: ['2'] }],
    disabled: false,
    spanNum: 24,
    options: [
      { label: '华法林', value: '1', disabled: false },
      { label: '新型抗凝剂', value: '2', disabled: false },
      { label: '阿司匹林', value: '3', disabled: false },
      { label: '氯吡格雷', value: '4', disabled: false },
      { label: '其他', value: '5', disabled: false },
    ],
    rules: [{ required: true, message: '请选择评分值', trigger: 'blur' }]
  },
  {
    formType: 'radio',
    prop: 'c22',
    model: 'c22',
    label: '用药情况',
    linkageRule: [{ name: 'c20', value: ['2'] }],
    disabled: false,
    spanNum: 24,
    options: [
      { label: '规律', value: '1', disabled: false },
      { label: '不规律', value: '2', disabled: false },
    ],
    rules: [{ required: true, message: '请选择是否', trigger: 'blur' }]
  },



  {
    formType: 'div',
    name: '3.4 高血压',
    className: 'sec-title',
  },
  {
    formType: 'radio',
    prop: 'c12',
    model: 'c12',
    label: '随访期间新发现有高血压',
    disabled: false,
    spanNum: 24,
    options: [
      { label: '否', value: '1', disabled: false },
      { label: '是', value: '2', disabled: false },
    ],
    rules: [{ required: true, message: '请选择是否', trigger: 'blur' }]
  },
  {
    formType: 'date-picker',
    prop: 'c23',
    model: 'c23',
    placeholder: '请选择',
    label: '首次确诊时间',
    linkageRule: [{ name: 'c12', value: ['2'] }],
    format: 'yyyy-MM-dd',
    type: 'date',
    rules: [{ required: true, message: '首次确诊时间', trigger: 'blur' }],
    spanNum: 24,
  },
  {
    formType: 'radio',
    prop: 'c13',
    model: 'c13',
    label: '是否有高血压（包括既往及本次随访期间新发现的高血压患者）',
    // linkageRule: [{ name: 'c1', value: ['2'] }],
    disabled: false,
    spanNum: 24,
    options: [
      { label: '无', value: '1', disabled: false },
      { label: '有', value: '2', disabled: false },
    ],
    rules: [{ required: true, message: '请选择是否', trigger: 'blur' }]
  },
  {
    formType: 'radio',
    prop: 'c24',
    model: 'c24',
    label: '是否服降压药',
    linkageRule: [{ name: 'c13', value: ['2'] }],
    disabled: false,
    spanNum: 24,
    options: [
      { label: '否', value: '1', disabled: false },
      { label: '是', value: '2', disabled: false },
    ],
    rules: [{ required: true, message: '请选择是否', trigger: 'blur' }]
  },
  {
    formType: 'radio',
    prop: 'c25',
    model: 'c25',
    label: '血压控制情况',
    linkageRule: [{ name: 'c13', value: ['2'] }],
    disabled: false,
    spanNum: 24,
    options: [
      { label: '达标', value: '1', disabled: false },
      { label: '不达标', value: '2', disabled: false },
      { label: '不清楚', value: '3', disabled: false },
    ],
    rules: [{ required: true, message: '请选择是否', trigger: 'blur' }]
  },



  {
    formType: 'div',
    name: '3.5 血脂异常',
    className: 'sec-title',
  },
  {
    formType: 'radio',
    prop: 'c38',
    model: 'c38',
    label: '随访期间是否新发现有血脂异常',
    disabled: false,
    spanNum: 24,
    options: [
      { label: '否', value: '1', disabled: false },
      { label: '是', value: '2', disabled: false },
    ],
    rules: [{ required: true, message: '请选择是否', trigger: 'blur' }]
  },
  {
    formType: 'radio',
    prop: 'c39',
    model: 'c39',
    label: '是否有血脂异常（包括既往及本次随访期间新发现的血脂异常患者）',
    disabled: false,
    spanNum: 24,
    options: [
      { label: '无', value: '1', disabled: false },
      { label: '有', value: '2', disabled: false },
    ],
    rules: [{ required: true, message: '请选择是否', trigger: 'blur' }]
  },




  {
    formType: 'div',
    name: '3.6 糖尿病',
    className: 'sec-title',
  },
  {
    formType: 'radio',
    prop: 'c40',
    model: 'c40',
    label: '随访期间是否新发现有糖尿病',
    disabled: false,
    spanNum: 24,
    options: [
      { label: '否', value: '1', disabled: false },
      { label: '是', value: '2', disabled: false },
    ],
    rules: [{ required: true, message: '请选择是否', trigger: 'blur' }]
  },
  {
    formType: 'radio',
    prop: 'c41',
    model: 'c41',
    label: '如果是糖尿病患者（包括既往及本次随访期间新发现的糖尿病患者）',
    disabled: false,
    spanNum: 24,
    options: [
      { label: '否', value: '1', disabled: false },
      { label: '是', value: '2', disabled: false },
    ],
    rules: [{ required: true, message: '请选择是否', trigger: 'blur' }]
  },

]
