import {getPlanList,
  getPlanDetail,
  getNodeTimeList,
  getNodeTimeContent,
  getResidentList,
  getGroupList,
  getResidentDetail,
  getBasicData,
  changePlan,
  getFormOptions,
  getFollowupTemplate,
  createFollowPlan} from '../../utils/followup/followapis'

export default {
  namespaced: true,
  state: {
    residentList: { //居民列表
      pageNum: 1, //当前页码
      pageSize: 10, //每页数据大小
      total: null,  //总数
    },
    groupList: [],  //分组列表
    residentDetail: {}, //居民详情,
    planDetail: {}, // 计划详情页,
    nodeTimeList: [], //随访时间节点列表,
    nodeContent: {}, //时间节点详情
    planOption: [], //随访计划select
    timeNodeList: [],
    setTimeNodeList: [], //新建计划设置时间节点
    planList: {}, //随访计划列表
    remarkOption: [], //随访计划备注常量
    markOptions: [], //随访 随访时间节点单位 常量
    followTypeList: [], //随访 随访方式 常量
    remindOptions: [], //随访 提醒医生天数 常量
    pushTimeOptions: [], //随访 推送患教提醒天数 常量
    planStatusOption: [], //随访计划状态常量
    formOptions: [],// 获取量表
    templateOptions: [ // 获取随访计划模板
      {
        id: 0,
        name: '目前请选择自定义模板作为测试'
      }
    ],
  },
  mutations: {
    GET_RESIDENT_LIST(state, payload) {
      state.residentList = payload
    },
    GET_GROUP_LIST(state, payload) {
      state.groupList = payload.labelDtoList
    },
    GET_RESIDENT_DETAIL(state, payload) {
      state.residentDetail = payload
      state.timeNodeList = payload.fPlanPatientDatilDtoList.timeNodeList
    },
    GET_PLAN_DETAIL(state, payload) {
      state.planDetail = payload
    },
    GET_REMARK_OPTION(state, payload) {
     state.remarkOption = payload.P211
    },
    GET_DATE_UNIT(state, payload){
      state.markOptions = payload.P017
    },
    GET_FOLLOW_TYPE_LIST(state, payload){
      state.followTypeList = payload.P212
    },
    GET_REMIND_OPTIONS(state, payload){
      state.remindOptions = payload.P213
    },
    GET_PUSH_TIME_OPTIONS(state, payload){
      state.pushTimeOptions = payload.P214
    },
    GET_PLAN_STATUS_OPTION(state, payload) {
      state.planStatusOption = payload.P216
    },
    GET_NODE_TIME_LIST(state, payload) {
      state.nodeTimeList = payload
    },
    GET_NODE_CONTENT(state, payload) {
      state.nodeContent = payload
    },
    GET_PLAN_OPTION(state, payload) {
      state.planOption = payload.fPlanDtoList
    },
    SET_TIME_NODE_LIST(state, payload) {
      state.setTimeNodeList = payload;
    },
    GET_PLAN_LIST(state, payload) {
      state.planList = payload
    },
    GET_FORM_OPTIONS(state, payload){
      state.formOptions = payload
    },
    GET_FOLLOW_TEMPLATE(state, payload){
      state.templateOptions = state.templateOptions.concat(payload)
    }
  },
  actions: {
    setFollowPlan(context, payload) {
      createFollowPlan({
        ...payload
      }).then(({data})=> {
       // console.log('成功',data)
      })
    },
    getResidentList(context, payload) {
      const { pageSize, pageNum } = context.state.residentList;
      getResidentList({
        pageSize,
        pageNum,
        ...payload
      }).then(({data}) => {
        context.commit('GET_RESIDENT_LIST', data);
      });
    },
    getGroupList(context, payload) {
      getGroupList({}).then(({data}) => {
        context.commit('GET_GROUP_LIST', data);
      });
    },
    getResidentDetail(context, payload) {
      getResidentDetail({
        ...payload
      }).then(({data}) => {
        context.commit('GET_RESIDENT_DETAIL', data);
      });
    },
    getPlanDetail(context, payload) {
      getPlanDetail(payload).then(({data}) => {
        context.commit('GET_PLAN_DETAIL', data);
      });
    },
    getRemarkOption(context, payload) {
      getBasicData({
        numList: 'P211'
      }).then(({data}) => {
        context.commit('GET_REMARK_OPTION', data);
      });
    },
    getDateUnit(context, payload){
      // 随访时间节点单位
      getBasicData({
        numList: 'P017'
      }).then(({data})=>{
        context.commit('GET_DATE_UNIT', data);
      })
    },
    getFollowTypeList(context, payload){
      // 随访方式
      getBasicData({
        numList: 'P212'
      }).then(({data})=>{
        context.commit('GET_FOLLOW_TYPE_LIST', data);
      })
    },
    getRemindOptions(context, payload){
      // 提醒医生天数
      getBasicData({
        numList: 'P213'
      }).then(({data})=>{
        context.commit('GET_REMIND_OPTIONS', data);
      })
    },
    getPushTimeOptions(context, payload){
      // 推送患教提醒天数
      getBasicData({
        numList: 'P214'
      }).then(({data})=>{
        context.commit('GET_PUSH_TIME_OPTIONS', data);
      })
    },
    getFormOptions(context, payload){
      // 获取量表
      getFormOptions().then(({data})=>{
        context.commit('GET_FORM_OPTIONS', data);
      })
    },
    getFollowupTemplate(context, payload){
      // 获取随访模板
      getFollowupTemplate().then(({data})=>{
        context.commit('GET_FOLLOW_TEMPLATE', data);
      })
    },
    getPlanStatusOption(context, payload) {
      getBasicData({
        numList: 'P216'
      }).then(({data}) => {
        context.commit('GET_PLAN_STATUS_OPTION', data);
      });
    },
    getNodeTimeList(context, payload) {
      getNodeTimeList(payload).then(({data}) => {
        context.commit('GET_NODE_TIME_LIST', data);
      });
    },
    getNodeTimeContent(context, payload) {
      getNodeTimeContent(payload).then(({data}) => {
        context.commit('GET_NODE_CONTENT', data);
      });
    },
    getPlanOptions(context, payload) {
      getPlanList({
        pageNum: -1
      }).then(({data}) => {
        context.commit('GET_PLAN_OPTION', data);
      });
    },
    changePlan(context, payload) {
      changePlan({

      }).then(({data}) => {
       // context.commit('GET_PLAN_OPTION', data);
      });
    },
    getTimeNodeList(context, payload){
      context.commit('SET_TIME_NODE_LIST', payload);
    },
    async getPlanList(context, payload) {
      await getPlanList({
        ...payload
      }).then(({data}) => {
        context.commit('GET_PLAN_LIST', data);
      });
    },
  },
}
