export default ($this) => {
  return [
    {
      formType: 'div',
      name: '5.1 一般体征',
      className: 'sec-title',
    },
    {
      formType: 'date-picker',
      className: 'float-none',
      prop: 'inspectTime',
      model: 'inspectTime',
      placeholder: '请选择',
      label: '检查时间：',
      format: 'yyyy-MM-dd',
      valueFormat: 'yyyy-MM-dd',
      dateType: 'date',
      type: 'date',
      rules: [{required: true, message: '手术时间', trigger: 'submit'}],
      spanNum: 6,
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'stature',
      model: 'stature',
      label: '身高：',
      disabled: false,
      placeholder: '请输入',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'cm', type: 'append'}],
      rules: [{required: true, message: '请输入身高', trigger: 'submit'}],
      changeFun: (val)=>{
        console.log(val)
        $this.addComponents.forEach((item,index)=>{
          if(item.formName == 'stroke_014'){
            $this.addComponents[index].formObject.stature = val
          }
        })
      },
      blurFunc: (val)=>{
        $this.addComponents.forEach((item,index)=>{
          if(item.formName == 'stroke_014'){
            console.log($this.addComponents[index].formObject)
            let weight = $this.addComponents[index].formObject.weight
            let stature = $this.addComponents[index].formObject.stature
            if(weight && stature){
              weight = parseFloat(weight);
              stature = parseFloat(stature);
              $this.addComponents[index].formObject.bmi = weight / Math.pow((stature/100),2);
              $this.addComponents[13].formObject.bmi = weight / Math.pow((stature/100),2);
              console.log($this.addComponents[index].formObject.bmi)
              $this.bmi = $this.addComponents[index].formObject.bmi
              item.formObject.bmi = weight / Math.pow((stature/100),2);
            }
          }
        })
      }
    },
    // 体质指数（BMI）=体重（kg）÷ 身高²（m）
    {
      formType: 'input',
      className: 'float-none',
      prop: 'weight',
      model: 'weight',
      label: '体重：',
      disabled: false,
      placeholder: '请输入（体重可以带1位小数点）',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'kg', type: 'append'}],
      rules: [{required: true, message: '请输入体重', trigger: 'submit'}],
      changeFun: (val)=>{
        console.log(val)
        $this.addComponents.forEach((item,index)=>{
          if(item.formName == 'stroke_014'){
            $this.addComponents[index].formObject.weight = val
          }
        })
      },
      blurFunc: (val)=>{
        $this.addComponents.forEach((item,index)=>{
          if(item.formName == 'stroke_014'){
            console.log($this.addComponents[index].formObject)
            let weight = $this.addComponents[index].formObject.weight
            let stature = $this.addComponents[index].formObject.stature
            if(weight && stature){
              weight = parseFloat(weight);
              stature = parseFloat(stature);
              $this.addComponents[index].formObject.bmi = weight / Math.pow((stature/100),2);
              console.log($this.addComponents[index].formObject.bmi)
              $this.bmi = $this.addComponents[index].formObject.bmi
              item.formObject.bmi = weight / Math.pow((stature/100),2);
            }
          }
        })
      }
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'bmi',
      model: 'bmi',
      label: 'BMI（系统自动生成）：',
      disabled: false,
      placeholder: '（这里是自动计算所得）',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'kg/m^2', type: 'append'}],
    },

    {
      formType: 'input',
      className: 'float-none',
      prop: 'waistline',
      model: 'waistline',
      label: '腰围：',
      disabled: false,
      placeholder: '请输入',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'cm', type: 'append'}],
      rules: [{required: true, message: '请输入腰围', trigger: 'submit'}],
    },


    {
      formType: 'div',
      name: '5.2 血压（同侧，测量2次）',
      className: 'sec-title',
    },
    {
      formType: 'date-picker',
      className: 'float-none',
      prop: 'measureTime',
      model: 'measureTime',
      placeholder: '请选择',
      label: '测量时间：',
      format: 'yyyy-MM-dd',
      valueFormat: 'yyyy-MM-dd',
      dateType: 'date',
      type: 'date',
      rules: [{required: true, message: '请选择测量时间', trigger: 'submit'}],
      spanNum: 6,
    },
    {
      formType: 'div',
      name: '第一次',
      className: 'third-title',
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'firstSystolicPressure',
      model: 'firstSystolicPressure',
      label: '收缩压SBP：',
      disabled: false,
      placeholder: '请输入',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'mmHg', type: 'append'}],
      rules: [{required: true, message: '请输入收缩压SBP', trigger: 'submit'}],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'firstDiastolicPressure',
      model: 'firstDiastolicPressure',
      label: '舒张压DBP：',
      disabled: false,
      placeholder: '请输入',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'mmHg', type: 'append'}],
      rules: [{required: true, message: '请输入舒张压DBP', trigger: 'submit'}],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'firstPulse',
      model: 'firstPulse',
      label: '脉搏：',
      disabled: false,
      placeholder: '请输入',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{name: '次/分', type: 'append'}],
      rules: [{required: true, message: '请输入脉搏', trigger: 'submit'}],
    },

    {
      formType: 'div',
      name: '第二次',
      className: 'third-title',
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'secondSystolicPressure',
      model: 'secondSystolicPressure',
      label: '收缩压SBP：',
      disabled: false,
      placeholder: '请输入',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'mmHg', type: 'append'}],
      rules: [{required: true, message: '请输入收缩压SBP', trigger: 'submit'}],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'secondDiastolicPressure',
      model: 'secondDiastolicPressure',
      label: '舒张压DBP：',
      disabled: false,
      placeholder: '请输入',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{name: 'mmHg', type: 'append'}],
      rules: [{required: true, message: '请输入舒张压DBP', trigger: 'submit'}],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'secondPulse',
      model: 'secondPulse',
      label: '脉搏：',
      disabled: false,
      placeholder: '请输入',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{name: '次/分', type: 'append'}],
      rules: [{required: true, message: '请输入脉搏', trigger: 'submit'}],
    },


    {
      formType: 'div',
      name: '5.3 心脏听诊',
      className: 'sec-title',
    },
    {
      formType: 'date-picker',
      className: 'float-none',
      prop: 'inspectTime1',
      model: 'inspectTime1',
      placeholder: '请选择',
      label: '测量时间：',
      format: 'yyyy-MM-dd',
      valueFormat: 'yyyy-MM-dd',
      dateType: 'date',
      type: 'date',
      rules: [{required: true, message: '测量时间', trigger: 'submit'}],
      spanNum: 6,
    },
    {
      formType: 'radio',
      className: 'float-none',
      prop: 'cardiacMurmur',
      model: 'cardiacMurmur',
      label: '心脏杂音：',
      disabled: false,
      spanNum: 6,
      options: [
        {label: '无', value: '无', disabled: false},
        {label: '有', value: '有', disabled: false},
      ],
      rules: [{required: true, message: '请选择心脏杂音', trigger: 'submit'}]
    },
    {
      formType: 'radio',
      className: 'float-none',
      prop: 'heartRhythm',
      model: 'heartRhythm',
      label: '心律',
      disabled: false,
      spanNum: 6,
      options: [
        {label: '整齐', value: '整齐', disabled: false},
        {label: '不齐', value: '不齐', disabled: false},
      ],
      rules: [{required: true, message: '请选择心律', trigger: 'submit'}]
    },
  ]
}
