const checkBarcode = (rule, value, cb) => {
  const valedBarcode = new RegExp("[\\u4E00-\\u9FFF]+","g"); 
  if(value && valedBarcode.test(value)) cb(new Error('条形码不能输入中文'));
  cb();
};

const checkNumber = (rule, value, cb) => {
  const val = String(value);
  const isInt = /^([1-9][0-9]*)$/;
  if(val && !isInt.test(val)) cb(new Error('请输入正整数'));
  cb();
};

const checkProjectStr = (rule, value, callback) => {
  if (value.indexOf("\\") != -1) {
    //存在
    callback(new Error("请勿输入字符“ \\ ”"));
  } else if (value.indexOf(".") != -1) {
    callback(new Error("请勿输入字符“ . ”"));
  } else {
    callback();
  }
};

const rules1 = {
  // barCode: [
  //   { required: true, message: "请输入条形码", trigger: "submit" },
  //   { validator: checkBarcode, trigger: "submit" }
  // ],
  medicCommonName:[
    { required: true, message: "请输入商品通用名称", trigger: "blur" }
  ],
  size:[
    { required: true, message: "请输入商品规格", trigger: "blur" }
  ],
  manufacturer:[
    { required: true, message: "请输入生产厂家", trigger: "blur" }
  ],
  approvalNumber:[
    { required: true, message: "请输入批准文号", trigger: "blur" }
  ],
  dosageId:[
    { required: true, message: "请选择剂型", trigger: "change" }
  ],
  categoryIdLevel2:[
    { required: true, message: "请选择药品类型", trigger: "blur" }
  ],
  categoryIdLevel3:[
    { required: true, message: "请选择一级类目", trigger: "blur" }
  ],
  categoryIdLevel4:[
    { required: true, message: "请选择二级类目", trigger: "blur" }
  ],
  categoryIdLevel5:[
    { required: true, message: "请选择三级类目", trigger: "blur" }
  ],
  specification_url:[
    { required: true, message: "请上传药品说明书", trigger: "blur" }
  ],
  // otc:[
  //   { required: true, message: "请选择是否是处方", trigger: "blur" }
  // ],
  dynamicFlag: [
    { required: true, message: "请选择内容发布权", trigger: "blur" },
  ],
}

const rules2 = {
  // barCode: [
  //   { required: true, message: "请输入条形码", trigger: "submit" },
  //   { validator: checkBarcode, trigger: "submit" }
  // ],
  checkName: [{ required: true, message: "请输入检测名称", trigger: "blur" }],
  hospitalName: [{ required: true, message: "请输入医疗机构名称", trigger: "blur" }],
  hospitalType: [{ required: true, message: "请选择医疗机构类型", trigger: "blur" }],
  checkItem: [{ required: true, message: "请输入检测项目", trigger: "blur" }],
  checkStandard: [{ required: true, message: "请输入检测指标", trigger: "blur" }],
  useCount: [{ required: true, message: "请输入使用人数", trigger: "submit" },{validator: checkNumber, trigger: "submit"}],
  checkType: [{ required: true, message: "请选择检测类型", trigger: "blur" }],
  suitableStr: [{ required: true, message: "请选择适用人群", trigger: "blur" }],
  endTime: [{ required: true, message: "请选择商品使用日期", trigger: "blur" }],
  // goodsCheckImages: [
  //   { required: true, message: "请上传检测说明图", trigger: "blur" }
  // ],
}

const rules = {
  barCode: [
    { required: true, message: "请输入条形码", trigger: "submit" },
    { validator: checkBarcode, trigger: "submit" }
  ],
  goodsName: [
    { required: true, message: "请输入商品名称", trigger: "submit" },
    { validator: checkProjectStr, trigger: "submit" }
  ],
  goodsHeaderImages: [
    { required: true, message: "请上传商品头图", trigger: "blur" }
  ],
  goodsType:[
    { required: true, message: "请选择商品类型", trigger: "change" }
  ],
  optPrice: [
    { required: true, message: "请输入零售价", trigger: "blur" },
  ],
  // introduce: [
  //   { required: true, message: "请输入圈子介绍", trigger: "blur" },
  //   {
  //     min: 2,
  //     max: 40,
  //     message: "输入长度为2-40的内容，可包含中英文、数字及特殊符号",
  //     trigger: "blur"
  //   },
  //   { validator: checkProjectStr, trigger: "blur" }
  // ],
}


export const originRules1 = rules1;
export const originRules2 = rules2;
export const originRules = rules;

 