import '@babel/polyfill'
import * as Vue from 'vue'
import * as VueRouter from 'vue-router'
import routes from './router/router'
import store from './store'
import FastClick from 'fastclick'
import vueFilters from '@/utils/filter'
import draggable from 'vuedraggable'
import utils from '@/utils/followup/followupUtils'
import ElementUI from 'element-plus'
// import 'element-plus/dist/index.css'
import 'element-ui/lib/theme-chalk/index.css'
//引入滚动加载分页
import infiniteScroll from 'vue-infinite-scroll'
import VueVideoPlayer from 'vue-video-player'
import { mixins } from '@/utils/mixins'
import 'video.js/dist/video-js.css'
// import pdf from 'vue-pdf'

window.$vueApp = Vue.createApp()

// const mixins = require('@/utils/mixins')
window.$vueApp.component('draggable', draggable)
// import '@/utils/toBlob';

window.$vueApp.use(infiniteScroll)
window.$vueApp.use(VueVideoPlayer)
// Vue.use(pdf);

// 可调试
// Vue.config.devtools = true;
// Vue.use(Logger, { prefix: new Date(), isDev: process.env.NODE_ENV === 'development', cLevel: 'debug' })

window.$vueApp.use(ElementUI)

// 注册所有公用过滤器
for (let key in vueFilters) {
  ;(
    window.$vueApp.config.globalProperties.$filters ||
    (window.$vueApp.config.globalProperties.$filters = {})
  ).key = vueFilters[key]
}

if ('addEventListener' in document) {
  document.addEventListener(
    'DOMContentLoaded',
    function () {
      FastClick.attach(document.body)
    },
    false
  )
}

const router = VueRouter.createRouter({
  history: VueRouter.createWebHashHistory(),
  routes: routes,
  history: VueRouter.createWebHashHistory(),
  strict: process.env.NODE_ENV !== 'production',
  scrollBehavior(to, from, savedPosition) {
    if (savedPosition) {
      return savedPosition
    } else {
      if (from.meta.keepAlive) {
        from.meta.savedPosition = document.body.scrollTop
      }
      return { left: 0, top: to.meta.savedPosition || 0 }
    }
  },
})

router.beforeEach((to, from, next) => {
  if (to.meta.checkAuth) {
    utils.checkAuthFunc().then((res) => {
      if (res == 3) {
        if (to.meta.doctorAuth) {
          utils.getDoctorAuth(router).then((resAuth) => {
            if (resAuth == 3) {
              next()
            } else {
              next(false)
              return
            }
          })
          return
        }
        next()
      } else {
        next({ path: '/home' })
        return
      }
    })
    return
  }
  next()
})

console.log('mixins', mixins)
// 加入混合
window.$vueApp.mixin(mixins)

window.$vueApp.use(store)
window.$vueApp.use(router)

window.$vueApp.mount('#app')
window.$vueApp.config.globalProperties.routerAppend = (path, pathToAppend) => {
  return path + (path.endsWith('/') ? '' : '/') + pathToAppend
}
