import followApi from '../../../utils/followup/followapis'

export default {
  namespaced: true,
  state: {
    reservationList: { //居民列表
      pageNum: 1, //当前页码
      pageSize: 10, //每页数据大小
      total: null,  //总数
    },
    checkRevervationData: {},//发送预约校验
    constantsData: {},//获取常量
  },
  mutations: {
    GET_RESERVATION_LIST(state, payload) {
      state.reservationList = payload
    },
    GET_CHECK_RESERVATION(state, payload) {
      state.checkRevervationData = payload
    },
    GET_CONSTANS_DATA(state, payload) {
      state.constantsData = payload
    },
  },
  actions: {
    getReservationList(context, payload) {
      const { pageSize, pageNum } = context.state.reservationList;
      followApi.getReservationList({
        pageSize,
        pageNum,
        ...payload
      }).then(({data}) => {
        context.commit('GET_RESERVATION_LIST', data);
      });
    },
    getCheckReservation(context, payload) {
      followApi.getCheckReservation({
        ...payload
      }).then(({data}) => {
        context.commit('GET_CHECK_RESERVATION', data)
      })
    },
    getConstantsData(context, payload) {
      followApi.getBasicData({
        ...payload
      }).then(({data}) => {
        context.commit('GET_CONSTANS_DATA', data)
      })
    },
  },
}
